/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.memcached;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationParser;
import org.infinispan.server.configuration.memcached.Attribute;
import org.infinispan.server.configuration.memcached.Element;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespaces(value={@Namespace(root="memcached-connector"), @Namespace(uri="urn:infinispan:server:*", root="memcached-connector")})
public class MemcachedServerConfigurationParser
implements ConfigurationParser {
    private static Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        if (!holder.inScope(ServerConfigurationParser.ENDPOINTS_SCOPE)) {
            throw coreLog.invalidScope(ServerConfigurationParser.ENDPOINTS_SCOPE, holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case MEMCACHED_CONNECTOR: {
                ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)builder.module(ServerConfigurationBuilder.class);
                if (serverBuilder != null) {
                    this.parseMemcached(reader, serverBuilder, serverBuilder.addConnector(MemcachedServerConfigurationBuilder.class));
                    break;
                }
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseMemcached(XMLExtendedStreamReader reader, ServerConfigurationBuilder serverBuilder, MemcachedServerConfigurationBuilder builder) throws XMLStreamException {
        String[] required = ParseUtils.requireAttributes((XMLStreamReader)reader, (Enum[])new Enum[]{Attribute.SOCKET_BINDING});
        serverBuilder.applySocketBinding(required[0], (ProtocolServerConfigurationBuilder)builder);
        builder.startTransport(true);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE_CONTAINER: {
                    continue block7;
                }
                case IDLE_TIMEOUT: {
                    builder.idleTimeout(Integer.parseInt(value));
                    continue block7;
                }
                case IO_THREADS: {
                    builder.ioThreads(Integer.parseInt(value));
                    continue block7;
                }
                case NAME: {
                    builder.name(value);
                    continue block7;
                }
                case SOCKET_BINDING: {
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }
}

