/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.server.security.HttpServerResponseAdapter;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerMechanismsResponder;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.Scope;

public class HttpServerRequestAdapter
implements HttpServerRequest {
    private final RestRequest request;
    private final ChannelHandlerContext ctx;
    NettyRestResponse.Builder responseBuilder;

    public HttpServerRequestAdapter(RestRequest request, ChannelHandlerContext ctx) {
        this.request = request;
        this.ctx = ctx;
        this.responseBuilder = new NettyRestResponse.Builder();
    }

    public List<String> getRequestHeaderValues(String s) {
        return this.request.headers(s);
    }

    public String getFirstRequestHeaderValue(String s) {
        return this.request.header(s);
    }

    public SSLSession getSSLSession() {
        SslHandler sslHandler = (SslHandler)this.ctx.pipeline().get(SslHandler.class.getName());
        return sslHandler != null ? sslHandler.engine().getSession() : null;
    }

    public Certificate[] getPeerCertificates() {
        SSLSession sslSession = this.getSSLSession();
        try {
            return sslSession != null ? sslSession.getPeerCertificates() : new Certificate[]{};
        }
        catch (SSLPeerUnverifiedException e) {
            throw new RuntimeException(e);
        }
    }

    public void noAuthenticationInProgress(HttpServerMechanismsResponder responder) {
        HttpServerResponseAdapter.adapt(responder, this.responseBuilder);
    }

    public void authenticationInProgress(HttpServerMechanismsResponder responder) {
        HttpServerResponseAdapter.adapt(responder, this.responseBuilder);
    }

    public void authenticationComplete(HttpServerMechanismsResponder responder) {
        HttpServerResponseAdapter.adapt(responder, this.responseBuilder);
    }

    public void authenticationComplete(HttpServerMechanismsResponder responder, Runnable runnable) {
        HttpServerResponseAdapter.adapt(responder, this.responseBuilder);
    }

    public void authenticationFailed(String s, HttpServerMechanismsResponder responder) {
        HttpServerResponseAdapter.adapt(responder, this.responseBuilder);
    }

    public void badRequest(HttpAuthenticationException e, HttpServerMechanismsResponder responder) {
        HttpServerResponseAdapter.adapt(responder, this.responseBuilder);
    }

    public String getRequestMethod() {
        return this.request.method().name();
    }

    public URI getRequestURI() {
        return URI.create(this.request.uri());
    }

    public String getRequestPath() {
        return this.request.path();
    }

    public Map<String, List<String>> getParameters() {
        return this.request.parameters();
    }

    public Set<String> getParameterNames() {
        return this.request.parameters().keySet();
    }

    public List<String> getParameterValues(String s) {
        return (List)this.request.parameters().get(s);
    }

    public String getFirstParameterValue(String s) {
        return (String)((List)this.request.parameters().get(s)).get(0);
    }

    public List<HttpServerCookie> getCookies() {
        return Collections.emptyList();
    }

    public InputStream getInputStream() {
        return null;
    }

    public InetSocketAddress getSourceAddress() {
        return (InetSocketAddress)this.ctx.channel().remoteAddress();
    }

    public boolean suspendRequest() {
        return false;
    }

    public boolean resumeRequest() {
        return false;
    }

    public HttpScope getScope(Scope scope) {
        return null;
    }

    public Collection<String> getScopeIds(Scope scope) {
        return null;
    }

    public HttpScope getScope(Scope scope, String s) {
        return null;
    }

    public RestResponse getResponse() {
        return this.responseBuilder.build();
    }
}

