/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.function.Supplier;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.security.ElytronHTTPAuthenticator;
import org.infinispan.server.security.ElytronSASLAuthenticationProvider;
import org.wildfly.security.auth.server.SecurityDomain;

public class ServerSecurityRealm {
    private final String name;
    private final SecurityDomain securityDomain;
    private final Supplier<Boolean> httpChallengeReadiness;

    public ServerSecurityRealm(String name, SecurityDomain securityDomain, Supplier<Boolean> httpChallengeReadiness) {
        this.name = name;
        this.securityDomain = securityDomain;
        this.httpChallengeReadiness = httpChallengeReadiness;
    }

    public ServerAuthenticationProvider getSASLAuthenticationProvider() {
        return new ElytronSASLAuthenticationProvider(this.name, this.securityDomain);
    }

    public Authenticator getHTTPAuthenticationProvider() {
        return new ElytronHTTPAuthenticator(this.name, this);
    }

    public boolean isReadyForHttpChallenge() {
        return this.httpChallengeReadiness.get();
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }
}

