/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.Protocol;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RestOperations {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    private final Protocol protocol;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(Common.HTTP_PROTOCOLS.size());
        for (Protocol protocol : Common.HTTP_PROTOCOLS) {
            params.add(new Object[]{protocol});
        }
        return params;
    }

    public RestOperations(Protocol protocol) {
        this.protocol = protocol;
    }

    @Test
    public void testRestOperations() {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.protocol(this.protocol);
        RestClient client = this.SERVER_TEST.getRestClient(builder, CacheMode.DIST_SYNC);
        RestCacheClient cache = client.cache(this.SERVER_TEST.getMethodName());
        RestResponse response = (RestResponse)Common.sync(cache.put("k1", "v1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
        response = (RestResponse)Common.sync(cache.get("k1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
        Assert.assertEquals((Object)"v1", (Object)response.getBody());
        response = (RestResponse)Common.sync(cache.remove("k1"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
        response = (RestResponse)Common.sync(cache.get("k1"));
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)this.protocol, (Object)response.getProtocol());
    }
}

