/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.infinispan.server.test.LdapServerRule;
import org.infinispan.server.test.category.Security;
import org.infinispan.test.Exceptions;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Security.class})
public class AuthorizationLDAPIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = new InfinispanServerRule(new InfinispanServerTestConfiguration("configuration/AuthorizationLDAPTest.xml"));
    @ClassRule
    public static LdapServerRule LDAP = new LdapServerRule(SERVERS);
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    final Map<String, ConfigurationBuilder> builderMap = new HashMap<String, ConfigurationBuilder>();
    final Map<String, String> bulkData;

    public AuthorizationLDAPIT() {
        this.addBuilder("admin", "strongPassword");
        this.addBuilder("writer", "somePassword");
        this.addBuilder("reader", "password");
        this.addBuilder("supervisor", "lessStrongPassword");
        this.bulkData = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            this.bulkData.put("k" + i, "v" + i);
        }
    }

    private void addBuilder(String username, String password) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().saslMechanism("SCRAM-SHA-1").serverName("infinispan").realm("default").username(username).password(password);
        this.builderMap.put(username, builder);
    }

    @Test
    public void testAdminCanDoEverything() {
        RemoteCache adminCache = this.SERVER_TEST.getHotRodCache(this.builderMap.get("admin"), CacheMode.DIST_SYNC);
        adminCache.put((Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", (Object)adminCache.get((Object)"k"));
        adminCache.putAll(this.bulkData);
        Assert.assertEquals((long)11L, (long)adminCache.size());
    }

    @Test
    public void testNonAdminsMustNotCreateCache() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> this.SERVER_TEST.getHotRodCache(this.builderMap.get(user), CacheMode.DIST_SYNC));
        }
    }

    @Test
    public void testWriterCannotRead() {
        this.createAuthzCache();
        RemoteCache<String, String> writerCache = this.SERVER_TEST.getHotRodCache(this.builderMap.get("writer"));
        writerCache.put((Object)"k1", (Object)"v1");
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> writerCache.get((Object)"k1"));
        for (String user : Arrays.asList("reader", "supervisor")) {
            RemoteCache<String, String> userCache = this.SERVER_TEST.getHotRodCache(this.builderMap.get(user));
            Assert.assertEquals((Object)"v1", (Object)userCache.get((Object)"k1"));
        }
    }

    @Test
    public void testReaderCannotWrite() {
        this.createAuthzCache();
        RemoteCache<String, String> readerCache = this.SERVER_TEST.getHotRodCache(this.builderMap.get("reader"));
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.put((Object)"k1", (Object)"v1"));
        for (String user : Arrays.asList("writer", "supervisor")) {
            RemoteCache<String, String> userCache = this.SERVER_TEST.getHotRodCache(this.builderMap.get(user));
            userCache.put((Object)user, (Object)user);
        }
    }

    @Test
    public void testBulkOperations() {
        this.createAuthzCache().putAll(this.bulkData);
        RemoteCache<String, String> readerCache = this.SERVER_TEST.getHotRodCache(this.builderMap.get("reader"));
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.getAll(this.bulkData.keySet()));
        RemoteCache<String, String> supervisorCache = this.SERVER_TEST.getHotRodCache(this.builderMap.get("supervisor"));
        supervisorCache.getAll(this.bulkData.keySet());
    }

    private RemoteCache<Object, Object> createAuthzCache() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).security().authorization().enable().role("AdminRole").role("ReaderRole").role("WriterRole").role("SupervisorRole");
        return this.SERVER_TEST.getHotRodCache(this.builderMap.get("admin"), (BasicConfiguration)builder.build());
    }
}

