/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Network;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.infinispan.commons.util.Version;
import org.infinispan.server.test.CountdownLatchLoggingConsumer;
import org.infinispan.server.test.InfinispanServerDriver;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.server.test.JBossLoggingConsumer;
import org.infinispan.test.Exceptions;
import org.infinispan.util.logging.LogFactory;
import org.jboss.logging.BasicLogger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;

public class ContainerInfinispanServerDriver
extends InfinispanServerDriver {
    public static final String INFINISPAN_SERVER_HOME = "/opt/infinispan";
    private final List<GenericContainer> containers;

    protected ContainerInfinispanServerDriver(InfinispanServerTestConfiguration configuration) {
        super(configuration, ContainerInfinispanServerDriver.getDockerBridgeAddress());
        this.containers = new ArrayList<GenericContainer>(configuration.numServers());
    }

    static InetAddress getDockerBridgeAddress() {
        DockerClient dockerClient = DockerClientFactory.instance().client();
        Network bridge = dockerClient.inspectNetworkCmd().withNetworkId("bridge").exec();
        String gateway = ((Network.Ipam.Config)bridge.getIpam().getConfig().get(0)).getGateway();
        return (InetAddress)Exceptions.unchecked(() -> InetAddress.getByName(gateway));
    }

    @Override
    protected void start(String name, File rootDir, String configurationFile) {
        ContainerInfinispanServerDriver.createServerHierarchy(rootDir);
        String baseImageName = System.getProperty("org.infinispan.test.server.baseImageName", "jboss/base-jdk:11");
        Path serverOutputDir = Paths.get(System.getProperty("server.output.dir"), new String[0]);
        ArrayList<String> args = new ArrayList<String>();
        args.add("bin/server.sh");
        args.add("-c");
        args.add(configurationFile);
        args.add("-b");
        args.add("SITE_LOCAL");
        args.add("-Djgroups.tcp.address=SITE_LOCAL");
        args.add("-Dinfinispan.cluster.name=" + name);
        args.add("-Dorg.infinispan.test.host.address=" + this.testHostAddress.getHostName());
        args.add("-Dcom.sun.management.jmxremote.port=9999");
        args.add("-Dcom.sun.management.jmxremote.authenticate=false");
        args.add("-Dcom.sun.management.jmxremote.ssl=false");
        this.configuration.properties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> args.add("-D" + k + "=" + v)));
        ImageFromDockerfile image = (ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile().withFileFromPath("build", serverOutputDir)).withFileFromPath("test", rootDir.toPath())).withFileFromPath("target", serverOutputDir.getParent())).withFileFromPath("src", serverOutputDir.getParent().getParent().resolve("src"))).withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(baseImageName)).env("INFINISPAN_SERVER_HOME", INFINISPAN_SERVER_HOME)).env("INFINISPAN_VERSION", Version.getVersion())).label("name", "Infinispan Server")).label("version", Version.getVersion())).label("release", Version.getVersion())).label("architecture", "x86_64")).user("jboss")).copy("build", INFINISPAN_SERVER_HOME)).copy("test", "/opt/infinispan/server")).copy("src/test/resources/bin", "/opt/infinispan/bin")).workDir(INFINISPAN_SERVER_HOME)).cmd(args.toArray(new String[0]))).expose(new Integer[]{11222, 11221, 7800, 43366, 9999})).build());
        CountdownLatchLoggingConsumer latch = this.configuration.numServers() > 1 ? new CountdownLatchLoggingConsumer(this.configuration.numServers(), ".*ISPN080001.*") : new CountdownLatchLoggingConsumer(1, ".*ISPN080001.*");
        for (int i = 0; i < this.configuration.numServers(); ++i) {
            GenericContainer container = new GenericContainer((Future)image);
            ContainerInfinispanServerDriver.createServerHierarchy(rootDir, Integer.toString(i), (hostDir, dir) -> {
                String containerDir = String.format("%s/server/%s", INFINISPAN_SERVER_HOME, dir);
                container.withFileSystemBind(hostDir.getAbsolutePath(), containerDir);
                hostDir.setWritable(true, false);
            });
            this.containers.add(container);
            container.withLogConsumer((Consumer)((Object)new JBossLoggingConsumer((BasicLogger)LogFactory.getLogger((String)name)).withPrefix(Integer.toString(i)))).withLogConsumer((Consumer)((Object)latch)).waitingFor((WaitStrategy)Wait.forListeningPort()).start();
        }
        Exceptions.unchecked(() -> latch.await(10L, TimeUnit.SECONDS));
    }

    @Override
    protected void stop() {
        for (GenericContainer container : this.containers) {
            container.stop();
        }
        this.containers.clear();
    }

    @Override
    public InetSocketAddress getServerAddress(int server, int port) {
        GenericContainer container = this.containers.get(server);
        InspectContainerResponse containerInfo = container.getContainerInfo();
        ContainerNetwork network = (ContainerNetwork)containerInfo.getNetworkSettings().getNetworks().values().iterator().next();
        return new InetSocketAddress(network.getIpAddress(), port);
    }

    @Override
    public void pause(int server) {
        Container.ExecResult result = (Container.ExecResult)Exceptions.unchecked(() -> this.containers.get(server).execInContainer(new String[]{"/opt/infinispan/bin/pause.sh"}));
        System.out.printf("[%d] PAUSE %s\n", server, result);
    }

    @Override
    public void resume(int server) {
        Container.ExecResult result = (Container.ExecResult)Exceptions.unchecked(() -> this.containers.get(server).execInContainer(new String[]{"/opt/infinispan/bin/resume.sh"}));
        System.out.printf("[%d] RESUME %s\n", server, result);
    }

    @Override
    public void stop(int server) {
        this.containers.get(server).stop();
    }

    @Override
    public void kill(int server) {
        Exceptions.unchecked(() -> this.containers.get(server).execInContainer(new String[]{"/opt/infinispan/bin/kill.sh"}));
    }

    @Override
    public MBeanServerConnection getJmxConnection(int server) {
        return (MBeanServerConnection)Exceptions.unchecked(() -> {
            GenericContainer container = this.containers.get(server);
            JMXServiceURL url = new JMXServiceURL("service:jmx:");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url);
            return jmxConnector.getMBeanServerConnection();
        });
    }
}

