/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

public class CountdownLatchLoggingConsumer
extends BaseConsumer<CountdownLatchLoggingConsumer> {
    private final CountDownLatch latch;
    private final Pattern pattern;

    public CountdownLatchLoggingConsumer(int count, String regex) {
        this.latch = new CountDownLatch(count);
        this.pattern = Pattern.compile(regex, 32);
    }

    public void accept(OutputFrame outputFrame) {
        String log = outputFrame.getUtf8String();
        if (this.pattern.matcher(log).matches()) {
            this.latch.countDown();
        }
    }

    public void await(long timeout, TimeUnit unit) throws InterruptedException {
        this.latch.await(timeout, unit);
    }
}

