/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.test.Exceptions;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class InfinispanServerTestMethodRule
implements TestRule {
    private final InfinispanServerRule infinispanServerRule;
    private String methodName;
    private List<Closeable> resources;

    public InfinispanServerTestMethodRule(InfinispanServerRule infinispanServerRule) {
        assert (infinispanServerRule != null);
        this.infinispanServerRule = infinispanServerRule;
    }

    public <T extends Closeable> T registerResource(T resource) {
        this.resources.add(resource);
        return resource;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                InfinispanServerTestMethodRule.this.before();
                try {
                    InfinispanServerTestMethodRule.this.methodName = description.getTestClass().getSimpleName() + "." + description.getMethodName();
                    base.evaluate();
                }
                finally {
                    InfinispanServerTestMethodRule.this.after();
                }
            }
        };
    }

    private void before() {
        this.resources = new ArrayList<Closeable>();
    }

    private void after() {
        this.resources.forEach(closeable -> Util.close((AutoCloseable)closeable));
        this.resources.clear();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public RemoteCache<String, String> getHotRodCache(ConfigurationBuilder clientConfigurationBuilder) {
        RemoteCacheManager remoteCacheManager = this.registerResource(this.infinispanServerRule.newHotRodClient(clientConfigurationBuilder));
        return remoteCacheManager.getCache(this.methodName);
    }

    public <K, V> RemoteCache<K, V> getHotRodCache(CacheMode mode) {
        return this.getHotRodCache(new ConfigurationBuilder(), mode);
    }

    public <K, V> RemoteCache<K, V> getHotRodCache(ConfigurationBuilder clientConfigurationBuilder, CacheMode cacheMode) {
        RemoteCacheManager remoteCacheManager = this.registerResource(this.infinispanServerRule.newHotRodClient(clientConfigurationBuilder));
        return remoteCacheManager.administration().getOrCreateCache(this.methodName, "org.infinispan." + cacheMode.name());
    }

    public <K, V> RemoteCache<K, V> getHotRodCache(ConfigurationBuilder clientConfigurationBuilder, BasicConfiguration cacheConfiguration) {
        RemoteCacheManager remoteCacheManager = this.registerResource(this.infinispanServerRule.newHotRodClient(clientConfigurationBuilder));
        return remoteCacheManager.administration().getOrCreateCache(this.methodName, cacheConfiguration);
    }

    public RestClient getRestClient(CacheMode mode) {
        return this.getRestClient(new RestClientConfigurationBuilder(), mode);
    }

    public RestClient getRestClient(RestClientConfigurationBuilder clientConfigurationBuilder, CacheMode mode) {
        RestClient restClient = this.registerResource(this.infinispanServerRule.newRestClient(clientConfigurationBuilder));
        RestResponse response = (RestResponse)Exceptions.unchecked(() -> (RestResponse)restClient.cache(this.methodName).createWithTemplate("org.infinispan." + mode.name(), new CacheContainerAdmin.AdminFlag[0]).toCompletableFuture().get(5L, TimeUnit.SECONDS));
        if (response.getStatus() != 200) {
            throw new RuntimeException("Could not create cache " + this.methodName + ", status = " + response.getStatus());
        }
        return restClient;
    }

    public CounterManager getCounterManager() {
        RemoteCacheManager remoteCacheManager = this.registerResource(this.infinispanServerRule.newHotRodClient());
        return RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)remoteCacheManager);
    }

    public MemcachedClient getMemcachedClient() {
        return this.registerResource(this.infinispanServerRule.newMemcachedClient()).getClient();
    }

    public MBeanServerConnection getJmxConnection(int server) {
        return this.infinispanServerRule.getServerDriver().getJmxConnection(server);
    }
}

