/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.NamedFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.Server;
import org.infinispan.server.hotrod.HotRodServer;

public class Extensions {
    private final Map<String, CacheEventFilterFactory> filterFactories = new HashMap<String, CacheEventFilterFactory>();
    private final Map<String, CacheEventConverterFactory> converterFactories = new HashMap<String, CacheEventConverterFactory>();
    private final Map<String, CacheEventFilterConverterFactory> filterConverterFactories = new HashMap<String, CacheEventFilterConverterFactory>();
    private final Map<String, KeyValueFilterConverterFactory> keyValueFilterConverterFactories = new HashMap<String, KeyValueFilterConverterFactory>();

    public void load(ClassLoader classLoader) {
        this.load(classLoader, CacheEventFilterFactory.class, this.filterFactories);
        this.load(classLoader, CacheEventConverterFactory.class, this.converterFactories);
        this.load(classLoader, CacheEventFilterConverterFactory.class, this.filterConverterFactories);
        this.load(classLoader, KeyValueFilterConverterFactory.class, this.keyValueFilterConverterFactories);
    }

    public void apply(HotRodServer server) {
        for (Map.Entry<String, CacheEventFilterFactory> entry : this.filterFactories.entrySet()) {
            server.addCacheEventFilterFactory(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, CacheEventFilterFactory> entry : this.converterFactories.entrySet()) {
            server.addCacheEventConverterFactory(entry.getKey(), (CacheEventConverterFactory)entry.getValue());
        }
        for (Map.Entry<String, CacheEventFilterFactory> entry : this.filterConverterFactories.entrySet()) {
            server.addCacheEventFilterConverterFactory(entry.getKey(), (CacheEventFilterConverterFactory)entry.getValue());
        }
        for (Map.Entry<String, CacheEventFilterFactory> entry : this.keyValueFilterConverterFactories.entrySet()) {
            server.addKeyValueFilterConverterFactory(entry.getKey(), (KeyValueFilterConverterFactory)entry.getValue());
        }
    }

    private <T> void load(ClassLoader classLoader, Class<T> contract, Map<String, T> map) {
        for (Object t : ServiceFinder.load(contract, (ClassLoader[])new ClassLoader[]{classLoader})) {
            NamedFactory name = t.getClass().getAnnotation(NamedFactory.class);
            if (name != null) {
                map.put(name.name(), t);
                Server.log.loadedExtension(name.name());
                continue;
            }
            Server.log.unnamedFactoryClass(t.getClass().getName());
        }
    }
}

