/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)org.infinispan.security.Security.doPrivileged(action);
    }

    static Properties getSystemProperties() {
        return SecurityActions.doPrivileged(() -> System.getProperties());
    }

    static void addSecurityProvider(Provider provider) {
        SecurityActions.doPrivileged(() -> {
            if (Security.getProvider(provider.getName()) == null) {
                Security.insertProviderAt(provider, 1);
            }
            return null;
        });
    }

    static void startCacheManager(EmbeddedCacheManager cacheManager) {
        PrivilegedAction<Void> action = () -> {
            cacheManager.start();
            return null;
        };
        SecurityActions.doPrivileged(action);
    }

    static boolean stopCacheManager(EmbeddedCacheManager cacheManager) {
        PrivilegedAction<Boolean> action = () -> {
            if (cacheManager.getStatus().allowInvocations()) {
                cacheManager.stop();
                return true;
            }
            return false;
        };
        return SecurityActions.doPrivileged(action);
    }

    static void startProtocolServer(ProtocolServer server, ProtocolServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        PrivilegedAction<Void> action = () -> {
            server.start(configuration, cacheManager);
            return null;
        };
        SecurityActions.doPrivileged(action);
    }

    static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager manager) {
        return (GlobalConfiguration)SecurityActions.doPrivileged(new GetCacheManagerConfigurationAction(manager));
    }
}

