/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.Provider;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestServer;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.Extensions;
import org.infinispan.server.SecurityActions;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.admin.ServerAdminOperationsHandler;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.logging.Log;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.router.router.impl.singleport.SinglePortEndpointRouter;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.routes.singleport.SinglePortRouteSource;
import org.infinispan.util.logging.LogFactory;
import org.wildfly.security.http.basic.WildFlyElytronHttpBasicProvider;
import org.wildfly.security.http.bearer.WildFlyElytronHttpBearerProvider;
import org.wildfly.security.http.cert.WildFlyElytronHttpClientCertProvider;
import org.wildfly.security.http.digest.WildFlyElytronHttpDigestProvider;
import org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider;
import org.wildfly.security.sasl.external.WildFlyElytronSaslExternalProvider;
import org.wildfly.security.sasl.localuser.WildFlyElytronSaslLocalUserProvider;
import org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider;
import org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider;
import org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider;

public class Server
implements ServerManagement {
    public static final Log log = (Log)LogFactory.getLog((String)"SERVER", Log.class);
    public static final String INFINISPAN_BIND_ADDRESS = "infinispan.bind.address";
    public static final String INFINISPAN_BIND_PORT = "infinispan.bind.port";
    public static final String INFINISPAN_CLUSTER_NAME = "infinispan.cluster.name";
    public static final String INFINISPAN_CLUSTER_STACK = "infinispan.cluster.stack";
    public static final String INFINISPAN_NODE_NAME = "infinispan.node.name";
    public static final String INFINISPAN_PORT_OFFSET = "infinispan.socket.binding.port-offset";
    public static final String INFINISPAN_SERVER_HOME_PATH = "infinispan.server.home.path";
    public static final String INFINISPAN_SERVER_ROOT_PATH = "infinispan.server.root.path";
    public static final String INFINISPAN_SERVER_CONFIG_PATH = "infinispan.server.config.path";
    public static final String INFINISPAN_SERVER_DATA_PATH = "infinispan.server.data.path";
    public static final String INFINISPAN_SERVER_LOG_PATH = "infinispan.server.log.path";
    private static final String SERVER_DEFAULTS = "infinispan-defaults.xml";
    public static final String DEFAULT_SERVER_CONFIG = "conf";
    public static final String DEFAULT_SERVER_DATA = "data";
    public static final String DEFAULT_SERVER_LIB = "lib";
    public static final String DEFAULT_SERVER_LOG = "log";
    public static final String DEFAULT_SERVER_ROOT_DIR = "server";
    public static final String DEFAULT_CONFIGURATION_FILE = "infinispan.xml";
    public static final String DEFAULT_CLUSTER_NAME = "cluster";
    public static final String DEFAULT_CLUSTER_STACK = "tcp";
    public static final int DEFAULT_BIND_PORT = 11222;
    private final TimeService timeService;
    private final File serverRoot;
    private final File serverConf;
    private final long startTime;
    private final Properties properties;
    private ExitHandler exitHandler = new DefaultExitHandler();
    private ConfigurationBuilderHolder defaultsHolder;
    private ConfigurationBuilderHolder configurationBuilderHolder;
    private Map<String, DefaultCacheManager> cacheManagers;
    private Map<String, ProtocolServer> protocolServers;
    private volatile ComponentStatus status;
    private ServerConfiguration serverConfiguration;
    private Extensions extensions;

    public Server() {
        this(new File(DEFAULT_SERVER_ROOT_DIR), new File(DEFAULT_CONFIGURATION_FILE), SecurityActions.getSystemProperties());
    }

    public Server(File serverRoot, File configuration, Properties properties) {
        this(serverRoot, properties);
        if (!configuration.isAbsolute()) {
            configuration = new File(this.serverConf, configuration.getPath());
        }
        try {
            this.parseConfiguration(configuration.toURI().toURL());
        }
        catch (IOException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    private Server(File serverRoot, Properties properties) {
        this.timeService = DefaultTimeService.INSTANCE;
        this.startTime = this.timeService.time();
        this.serverRoot = serverRoot;
        this.properties = properties;
        this.status = ComponentStatus.INSTANTIATED;
        properties.putIfAbsent(INFINISPAN_SERVER_ROOT_PATH, serverRoot);
        properties.putIfAbsent(INFINISPAN_SERVER_CONFIG_PATH, new File(serverRoot, DEFAULT_SERVER_CONFIG).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_DATA_PATH, new File(serverRoot, DEFAULT_SERVER_DATA).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_SERVER_LOG_PATH, new File(serverRoot, DEFAULT_SERVER_LOG).getAbsolutePath());
        properties.putIfAbsent(INFINISPAN_BIND_PORT, (Object)11222);
        properties.putIfAbsent(INFINISPAN_CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
        properties.putIfAbsent(INFINISPAN_CLUSTER_STACK, DEFAULT_CLUSTER_STACK);
        this.serverConf = new File(properties.getProperty(INFINISPAN_SERVER_CONFIG_PATH));
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpBasicProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpBearerProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpDigestProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronHttpClientCertProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslPlainProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslDigestProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslScramProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslExternalProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslLocalUserProvider.getInstance());
        SecurityActions.addSecurityProvider((Provider)WildFlyElytronSaslOAuth2Provider.getInstance());
    }

    private void parseConfiguration(URL config) {
        ParserRegistry parser = new ParserRegistry(this.getClass().getClassLoader(), false, this.properties);
        try {
            URL defaults = this.getClass().getClassLoader().getResource(SERVER_DEFAULTS);
            this.defaultsHolder = parser.parse(defaults);
            this.configurationBuilderHolder = new ConfigurationBuilderHolder();
            this.configurationBuilderHolder.getGlobalConfigurationBuilder().read(this.defaultsHolder.getGlobalConfigurationBuilder().build());
            for (Map.Entry entry : this.defaultsHolder.getNamedConfigurationBuilders().entrySet()) {
                this.configurationBuilderHolder.newConfigurationBuilder((String)entry.getKey()).read(((ConfigurationBuilder)entry.getValue()).build());
            }
            this.configurationBuilderHolder = parser.parse(config, this.configurationBuilderHolder);
            ServerAdminOperationsHandler adminOperationsHandler = new ServerAdminOperationsHandler(this.defaultsHolder);
            ServerConfigurationBuilder serverConfigurationBuilder = (ServerConfigurationBuilder)this.configurationBuilderHolder.getGlobalConfigurationBuilder().module(ServerConfigurationBuilder.class);
            serverConfigurationBuilder.connectors().forEach(builder -> builder.adminOperationsHandler((AdminOperationsHandler)adminOperationsHandler));
            for (Map.Entry entry : this.configurationBuilderHolder.getNamedConfigurationBuilders().entrySet()) {
                Configuration cfg = ((ConfigurationBuilder)entry.getValue()).build();
                ConfigurationBuilder defaultCfg = (ConfigurationBuilder)this.defaultsHolder.getNamedConfigurationBuilders().get("org.infinispan." + cfg.clustering().cacheMode().name());
                ConfigurationBuilder rebased = new ConfigurationBuilder().read(defaultCfg.build());
                rebased.read(cfg);
                entry.setValue(rebased);
            }
            this.configurationBuilderHolder.validate();
        }
        catch (IOException | XMLStreamException e) {
            throw new CacheConfigurationException(e);
        }
    }

    public ExitHandler getExitHandler() {
        return this.exitHandler;
    }

    public void setExitHandler(ExitHandler exitHandler) {
        if (this.status != ComponentStatus.INSTANTIATED) {
            throw new IllegalStateException("Cannot change exit handler on a running server");
        }
        this.exitHandler = exitHandler;
    }

    public synchronized CompletableFuture<Integer> run() {
        CompletionStage<Integer> r = this.exitHandler.getExitFuture();
        if (this.status == ComponentStatus.RUNNING) {
            return r;
        }
        this.cacheManagers = new LinkedHashMap<String, DefaultCacheManager>(1);
        this.protocolServers = new LinkedHashMap<String, ProtocolServer>(3);
        try {
            this.extensions = new Extensions();
            this.extensions.load(this.getClass().getClassLoader());
            DefaultCacheManager cm = new DefaultCacheManager(this.configurationBuilderHolder, false);
            this.cacheManagers.put(cm.getName(), cm);
            SecurityActions.startCacheManager((EmbeddedCacheManager)cm);
            this.serverConfiguration = (ServerConfiguration)SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)cm).module(ServerConfiguration.class);
            SinglePortRouteSource routeSource = new SinglePortRouteSource();
            ConcurrentHashMap routes = new ConcurrentHashMap();
            this.serverConfiguration.endpoints().connectors().parallelStream().forEach(configuration -> {
                try {
                    Class<ProtocolServer> protocolServerClass = configuration.getClass().getAnnotation(ConfigurationFor.class).value().asSubclass(ProtocolServer.class);
                    ProtocolServer protocolServer = (ProtocolServer)Util.getInstance(protocolServerClass);
                    if (protocolServer instanceof RestServer) {
                        ((RestServer)protocolServer).setServer((ServerManagement)this);
                    }
                    this.protocolServers.put(protocolServer.getName() + "-" + configuration.name(), protocolServer);
                    SecurityActions.startProtocolServer(protocolServer, configuration, (EmbeddedCacheManager)cm);
                    ProtocolServerConfiguration protocolConfig = protocolServer.getConfiguration();
                    if (protocolConfig.startTransport()) {
                        log.protocolStarted(protocolServer.getName(), protocolConfig.host(), protocolConfig.port());
                    } else {
                        if (protocolServer instanceof HotRodServer) {
                            routes.put(new Route((RouteSource)routeSource, (RouteDestination)new HotRodServerRouteDestination(protocolServer.getName(), (HotRodServer)protocolServer)), 0);
                            this.extensions.apply((HotRodServer)protocolServer);
                        } else if (protocolServer instanceof RestServer) {
                            routes.put(new Route((RouteSource)routeSource, (RouteDestination)new RestServerRouteDestination(protocolServer.getName(), (RestServer)protocolServer)), 0);
                        }
                        log.protocolStarted(protocolServer.getName());
                    }
                }
                catch (Throwable t) {
                    System.err.println(t.getMessage());
                    t.printStackTrace();
                }
            });
            SinglePortRouterConfiguration singlePortRouter = this.serverConfiguration.endpoints().singlePortRouter();
            SinglePortEndpointRouter endpointServer = new SinglePortEndpointRouter(singlePortRouter);
            endpointServer.start(new RoutingTable(routes.keySet()));
            this.protocolServers.put("endpoint", (ProtocolServer)endpointServer);
            log.protocolStarted(endpointServer.getName(), singlePortRouter.host(), singlePortRouter.port());
            this.status = ComponentStatus.RUNNING;
            log.serverStarted(Version.getBrandName(), Version.getVersion(), this.timeService.timeDuration(this.startTime, TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            r.completeExceptionally(e);
        }
        r = r.whenComplete((status, t) -> this.shutdown());
        return r;
    }

    public ConfigurationInfo getConfiguration() {
        return this.serverConfiguration;
    }

    private void shutdown() {
        this.status = ComponentStatus.STOPPING;
        this.protocolServers.values().parallelStream().forEach(ProtocolServer::stop);
        this.cacheManagers.values().forEach(cm -> SecurityActions.stopCacheManager((EmbeddedCacheManager)cm));
        this.status = ComponentStatus.TERMINATED;
    }

    public void stop() {
        this.getExitHandler().exit(0);
    }

    public Set<String> cacheManagerNames() {
        return this.cacheManagers.keySet();
    }

    public DefaultCacheManager getCacheManager(String name) {
        return this.cacheManagers.get(name);
    }

    public CompletionStage<Void> ignoreCache(String cacheManager, String cache) {
        ProtocolServer protocolServer = this.protocolServers.values().iterator().next();
        return protocolServer.ignoreCache(cache);
    }

    public CompletionStage<Boolean> unIgnoreCache(String cacheManager, String cache) {
        ProtocolServer protocolServer = this.protocolServers.values().iterator().next();
        return protocolServer.unignore(cache);
    }

    public CompletionStage<Collection<String>> ignoredCaches(String cacheManager) {
        ProtocolServer protocolServer = this.protocolServers.values().iterator().next();
        return protocolServer.getIgnoredCaches(cacheManager);
    }

    public ConfigurationBuilderHolder getConfigurationBuilderHolder() {
        return this.configurationBuilderHolder;
    }

    public File getServerRoot() {
        return this.serverRoot;
    }

    public Map<String, DefaultCacheManager> getCacheManagers() {
        return this.cacheManagers;
    }

    public Map<String, ProtocolServer> getProtocolServers() {
        return this.protocolServers;
    }
}

