/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.counter.api.SyncWeakCounter;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class HotRodCounterOperations {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testCounters() {
        CounterManager counterManager = this.SERVER_TEST.getCounterManager();
        counterManager.defineCounter("c1", CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).upperBound(10L).initialValue(1L).build());
        counterManager.defineCounter("c2", CounterConfiguration.builder((CounterType)CounterType.WEAK).initialValue(5L).build());
        SyncStrongCounter c1 = counterManager.getStrongCounter("c1").sync();
        SyncWeakCounter c2 = counterManager.getWeakCounter("c2").sync();
        Assert.assertEquals((long)1L, (long)c1.getValue());
        Assert.assertEquals((long)5L, (long)c2.getValue());
    }
}

