/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class IgnoreCaches {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final ObjectMapper mapper = new ObjectMapper();
    private static final String CACHE_MANAGER = "default";

    @Test
    public void testIgnoreCaches() throws Exception {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        RestClient client = this.SERVER_TEST.rest().withClientConfiguration(builder).create();
        String testCache = this.SERVER_TEST.getMethodName();
        Assert.assertTrue((boolean)this.getIgnoredCaches(client, CACHE_MANAGER).isEmpty());
        this.assertCacheResponse(client, testCache, 404);
        this.assertCacheResponse(client, "___protobuf_metadata", 404);
        this.ignoreCache(client, testCache);
        Assert.assertEquals(Collections.singleton(testCache), this.getIgnoredCaches(client, CACHE_MANAGER));
        this.assertCacheResponse(client, testCache, 503);
        this.assertCacheResponse(client, "___protobuf_metadata", 404);
        this.ignoreCache(client, "___protobuf_metadata");
        Assert.assertEquals(this.asSet(testCache, "___protobuf_metadata"), this.getIgnoredCaches(client, CACHE_MANAGER));
        this.assertCacheResponse(client, testCache, 503);
        this.assertCacheResponse(client, "___protobuf_metadata", 503);
        this.unIgnoreCache(client, testCache);
        Assert.assertEquals(Collections.singleton("___protobuf_metadata"), this.getIgnoredCaches(client, CACHE_MANAGER));
        this.assertCacheResponse(client, testCache, 404);
        this.assertCacheResponse(client, "___protobuf_metadata", 503);
        this.unIgnoreCache(client, "___protobuf_metadata");
        Assert.assertTrue((boolean)this.getIgnoredCaches(client, CACHE_MANAGER).isEmpty());
        this.assertCacheResponse(client, testCache, 404);
        this.assertCacheResponse(client, "___protobuf_metadata", 404);
    }

    private Set<String> asSet(String ... elements) {
        return Arrays.stream(elements).collect(Collectors.toSet());
    }

    private void assertCacheResponse(RestClient client, String cacheName, int code) {
        RestResponse restResponse = (RestResponse)Common.sync(client.cache(cacheName).get("whatever"));
        Assert.assertEquals((long)code, (long)restResponse.getStatus());
    }

    private void unIgnoreCache(RestClient client, String cacheName) {
        RestResponse response = (RestResponse)Common.sync(client.server().unIgnoreCache(CACHE_MANAGER, cacheName));
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    private void ignoreCache(RestClient client, String cacheName) {
        RestResponse response = (RestResponse)Common.sync(client.server().ignoreCache(CACHE_MANAGER, cacheName));
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    private Set<String> getIgnoredCaches(RestClient client, String cacheManagerName) throws Exception {
        RestResponse response = (RestResponse)Common.sync(client.server().listIgnoredCaches(cacheManagerName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        HashSet<String> res = new HashSet<String>();
        this.mapper.readTree(response.getBody()).elements().forEachRemaining(n -> res.add(n.asText()));
        return res;
    }
}

