/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestMetricsClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RestMetricsResource {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testOpenMetrics() {
        RestMetricsClient metricsClient = this.SERVER_TEST.rest().create().metrics();
        RestResponse response = (RestResponse)Common.sync(metricsClient.metrics(true));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.contentType());
        String metricsText = response.getBody();
        Assert.assertTrue((boolean)metricsText.contains("# TYPE application_Cache_Statistics_stores gauge"));
        response = (RestResponse)Common.sync(metricsClient.metrics("application/Cache_Statistics_stores", true));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        metricsText = response.getBody();
        Assert.assertTrue((boolean)metricsText.contains("# TYPE application_Cache_Statistics_stores gauge"));
    }

    @Test
    public void testMicroprofileMetrics() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestMetricsClient metricsClient = client.metrics();
        String cacheNameTag = this.SERVER_TEST.getMethodName() + "(" + CacheMode.DIST_SYNC.toString().toLowerCase() + ")";
        RestResponse response = (RestResponse)Common.sync(metricsClient.metrics());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)response.contentType());
        String metricsJson = response.getBody();
        JsonNode node = this.mapper.readTree(metricsJson);
        Assert.assertNotNull((Object)node.get("base"));
        Assert.assertNotNull((Object)node.get("vendor"));
        Assert.assertNotNull((Object)node.get("application"));
        Assert.assertTrue((boolean)metricsJson.contains("Cache_Statistics_stores"));
        response = (RestResponse)Common.sync(metricsClient.metrics("application/Cache_Statistics_stores"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        long totalStoresBefore = RestMetricsResource.streamNodeFields(this.mapper.readTree(response.getBody())).filter(e -> ((String)e.getKey()).contains(cacheNameTag)).map(e -> ((JsonNode)e.getValue()).asLong()).reduce(0L, Long::sum);
        Assert.assertEquals((long)0L, (long)totalStoresBefore);
        RestCacheClient cache = client.cache(this.SERVER_TEST.getMethodName());
        int NUM_PUTS = 10;
        for (int i = 0; i < NUM_PUTS; ++i) {
            RestResponse putResp = (RestResponse)Common.sync(cache.put("k" + i, "v" + i));
            Assert.assertEquals((long)204L, (long)putResp.getStatus());
        }
        response = (RestResponse)Common.sync(metricsClient.metrics("application/Cache_Statistics_stores"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String metricJson = response.getBody();
        long totalStoresAfter = RestMetricsResource.streamNodeFields(this.mapper.readTree(metricJson)).filter(e -> ((String)e.getKey()).contains(cacheNameTag)).map(e -> ((JsonNode)e.getValue()).asLong()).reduce(0L, Long::sum);
        Assert.assertEquals((long)NUM_PUTS, (long)totalStoresAfter);
    }

    @Test
    public void testMicroprofileMetricsMetadata() throws Exception {
        RestMetricsClient metricsClient = this.SERVER_TEST.rest().create().metrics();
        RestResponse response = (RestResponse)Common.sync(metricsClient.metricsMetadata());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)response.contentType());
        String metricsMetadataJson = response.getBody();
        Assert.assertTrue((boolean)metricsMetadataJson.contains("Cache_Statistics_stores"));
        response = (RestResponse)Common.sync(metricsClient.metricsMetadata("application/Cache_Statistics_stores"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        metricsMetadataJson = response.getBody();
        JsonNode node = this.mapper.readTree(metricsMetadataJson);
        Assert.assertNotNull((Object)node.get("Cache_Statistics_stores"));
        Assert.assertEquals((Object)"gauge", (Object)node.get("Cache_Statistics_stores").get("type").asText());
        Assert.assertEquals((Object)"stores", (Object)node.get("Cache_Statistics_stores").get("displayName").asText());
    }

    private static Stream<Map.Entry<String, JsonNode>> streamNodeFields(JsonNode node) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(node.fields(), 1024), false);
    }
}

