/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.IOException;
import java.util.function.Function;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RestRouter {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testRestRouting() {
        Function<String, RestClientConfiguration> cfgFromCtx = c -> new RestClientConfigurationBuilder().contextPath(c).build();
        try (RestClient restCtx = RestClient.forConfiguration((RestClientConfiguration)cfgFromCtx.apply("/rest"));
             RestClient invalidCtx = RestClient.forConfiguration((RestClientConfiguration)cfgFromCtx.apply("/invalid"));
             RestClient emptyCtx = RestClient.forConfiguration((RestClientConfiguration)cfgFromCtx.apply("/"));){
            RestResponse response = (RestResponse)Common.sync(restCtx.server().info());
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertTrue((boolean)response.getBody().contains("version"));
            response = (RestResponse)Common.sync(emptyCtx.server().info());
            Assert.assertEquals((long)404L, (long)response.getStatus());
            Assert.assertFalse((boolean)response.getBody().contains("cache"));
            response = (RestResponse)Common.sync(invalidCtx.server().info());
            Assert.assertEquals((long)404L, (long)response.getStatus());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

