/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resilience;

import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.rest.RestClient;
import org.infinispan.commons.util.Eventually;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.ContainerInfinispanServerDriver;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.infinispan.server.test.ServerRunMode;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class GracefulShutdownRestartIT {
    @ClassRule
    public static final InfinispanServerRule SERVER = new InfinispanServerRule(new InfinispanServerTestConfiguration("configuration/ClusteredServerTest.xml").numServers(2).runMode(ServerRunMode.CONTAINER));
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVER);

    @Test
    public void testGracefulShutdownRestart() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).persistence().addSingleFileStore();
        RemoteCache hotRod = ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withServerConfiguration(builder)).create();
        for (int i = 0; i < 100; ++i) {
            hotRod.put((Object)String.format("k%03d", i), (Object)String.format("v%03d", i));
        }
        RestClient rest = this.SERVER_TEST.rest().get();
        Common.sync(rest.cluster().stop());
        ContainerInfinispanServerDriver serverDriver = (ContainerInfinispanServerDriver)SERVER.getServerDriver();
        Eventually.eventually((String)"Cluster did not shutdown within timeout", () -> !serverDriver.isRunning(0) && !serverDriver.isRunning(1), (long)10L, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        serverDriver.restartCluster();
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)String.format("v%03d", i), (Object)hotRod.get((Object)String.format("k%03d", i)));
        }
    }
}

