/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.infinispan.server.test.LdapServerRule;
import org.infinispan.server.test.category.Security;
import org.infinispan.test.Exceptions;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Security.class})
public class AuthorizationLDAPIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = new InfinispanServerRule(new InfinispanServerTestConfiguration("configuration/AuthorizationLDAPTest.xml"));
    @ClassRule
    public static LdapServerRule LDAP = new LdapServerRule(SERVERS);
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    final Map<String, ConfigurationBuilder> builderMap = new HashMap<String, ConfigurationBuilder>();
    final Map<String, String> bulkData;

    public AuthorizationLDAPIT() {
        this.addBuilder("admin", "strongPassword");
        this.addBuilder("writer", "somePassword");
        this.addBuilder("reader", "password");
        this.addBuilder("supervisor", "lessStrongPassword");
        this.bulkData = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            this.bulkData.put("k" + i, "v" + i);
        }
    }

    private void addBuilder(String username, String password) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.security().authentication().saslMechanism("SCRAM-SHA-1").serverName("infinispan").realm("default").username(username).password(password);
        this.builderMap.put(username, builder);
    }

    @Test
    public void testAdminCanDoEverything() {
        RemoteCache adminCache = ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withClientConfiguration(this.builderMap.get("admin")).withCacheMode(CacheMode.DIST_SYNC)).create();
        adminCache.put((Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", (Object)adminCache.get((Object)"k"));
        adminCache.putAll(this.bulkData);
        Assert.assertEquals((long)11L, (long)adminCache.size());
    }

    @Test
    public void testNonAdminsMustNotCreateCache() {
        for (String user : Arrays.asList("reader", "writer", "supervisor")) {
            Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withClientConfiguration(this.builderMap.get(user)).withCacheMode(CacheMode.DIST_SYNC)).create());
        }
    }

    @Test
    public void testWriterCannotRead() {
        this.createAuthzCache();
        RemoteCache writerCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.builderMap.get("writer")).get();
        writerCache.put((Object)"k1", (Object)"v1");
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> writerCache.get((Object)"k1"));
        for (String user : Arrays.asList("reader", "supervisor")) {
            RemoteCache userCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.builderMap.get(user)).get();
            Assert.assertEquals((Object)"v1", (Object)userCache.get((Object)"k1"));
        }
    }

    @Test
    public void testReaderCannotWrite() {
        this.createAuthzCache();
        RemoteCache readerCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.builderMap.get("reader")).get();
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.put((Object)"k1", (Object)"v1"));
        for (String user : Arrays.asList("writer", "supervisor")) {
            RemoteCache userCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.builderMap.get(user)).get();
            userCache.put((Object)user, (Object)user);
        }
    }

    @Test
    public void testBulkOperations() {
        this.createAuthzCache().putAll(this.bulkData);
        RemoteCache readerCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.builderMap.get("reader")).get();
        Exceptions.expectException(HotRodClientException.class, (String)"(?s).*ISPN000287.*", () -> readerCache.getAll(this.bulkData.keySet()));
        RemoteCache supervisorCache = this.SERVER_TEST.hotrod().withClientConfiguration(this.builderMap.get("supervisor")).get();
        supervisorCache.getAll(this.bulkData.keySet());
    }

    private RemoteCache<Object, Object> createAuthzCache() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).security().authorization().enable().role("AdminRole").role("ReaderRole").role("WriterRole").role("SupervisorRole");
        return ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withClientConfiguration(this.builderMap.get("admin")).withServerConfiguration(builder)).create();
    }
}

