/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.server.test.InfinispanServerDriver;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.test.Exceptions;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.model.Statement;

public class InfinispanServerRule
implements TestRule {
    public static final Log log = LogFactory.getLog(InfinispanServerRule.class);
    private final InfinispanServerTestConfiguration configuration;
    private final InfinispanServerDriver serverDriver;

    public InfinispanServerRule(InfinispanServerTestConfiguration configuration) {
        this.configuration = configuration;
        this.serverDriver = configuration.runMode().newDriver(configuration);
    }

    public InfinispanServerDriver getServerDriver() {
        return this.serverDriver;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                boolean inSuite;
                String testName = description.getTestClass().getName();
                RunWith runWith = description.getTestClass().getAnnotation(RunWith.class);
                boolean bl = inSuite = runWith != null && runWith.value() == Suite.class;
                if (!inSuite) {
                    TestResourceTracker.testStarted((String)testName);
                }
                boolean manageServer = InfinispanServerRule.this.serverDriver.getStatus() == ComponentStatus.INSTANTIATED;
                try {
                    if (manageServer) {
                        InfinispanServerRule.this.serverDriver.before(testName);
                    }
                    InfinispanServerRule.this.before(testName);
                    base.evaluate();
                }
                finally {
                    InfinispanServerRule.this.after(testName);
                    if (manageServer) {
                        InfinispanServerRule.this.serverDriver.after(testName);
                    }
                    if (!inSuite) {
                        TestResourceTracker.testFinished((String)testName);
                    }
                }
            }
        };
    }

    private void before(String name) {
    }

    private void after(String name) {
    }

    RemoteCacheManager newHotRodClient() {
        return this.newHotRodClient(new ConfigurationBuilder());
    }

    RemoteCacheManager newHotRodClient(ConfigurationBuilder builder) {
        for (int i = 0; i < this.serverDriver.configuration.numServers(); ++i) {
            InetSocketAddress serverAddress = this.serverDriver.getServerSocket(i, 11222);
            builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        }
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(builder.build());
        return remoteCacheManager;
    }

    public RestClient newRestClient() {
        return this.newRestClient(new RestClientConfigurationBuilder());
    }

    public RestClient newRestClient(RestClientConfigurationBuilder builder) {
        for (int i = 0; i < this.serverDriver.configuration.numServers(); ++i) {
            InetSocketAddress serverAddress = this.serverDriver.getServerSocket(i, 11222);
            builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        }
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    CloseableMemcachedClient newMemcachedClient() {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (int i = 0; i < this.serverDriver.configuration.numServers(); ++i) {
            InetSocketAddress unresolved = this.serverDriver.getServerSocket(i, 11221);
            addresses.add(new InetSocketAddress(unresolved.getHostName(), unresolved.getPort()));
        }
        MemcachedClient memcachedClient = (MemcachedClient)Exceptions.unchecked(() -> new MemcachedClient(addresses));
        return new CloseableMemcachedClient(memcachedClient);
    }

    public static class CloseableMemcachedClient
    implements Closeable {
        final MemcachedClient client;

        public CloseableMemcachedClient(MemcachedClient client) {
            this.client = client;
        }

        public MemcachedClient getClient() {
            return this.client;
        }

        @Override
        public void close() {
            this.client.shutdown();
        }
    }
}

