/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import java.util.Properties;
import org.infinispan.server.test.ServerRunMode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class InfinispanServerTestConfiguration {
    private final String configurationFile;
    private int numServers = 2;
    private ServerRunMode runMode = ServerRunMode.DEFAULT;
    private Properties properties = new Properties();
    private String[] mavenArtifacts;
    private JavaArchive[] artifacts;
    private boolean jmx;

    public InfinispanServerTestConfiguration(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public InfinispanServerTestConfiguration numServers(int numServers) {
        this.numServers = numServers;
        return this;
    }

    public InfinispanServerTestConfiguration runMode(ServerRunMode runMode) {
        this.runMode = runMode;
        return this;
    }

    public InfinispanServerTestConfiguration property(String name, String value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public InfinispanServerTestConfiguration artifacts(JavaArchive ... artifacts) {
        assert (this.runMode == ServerRunMode.CONTAINER) : "Artifacts can be added only when runMode == CONTAINER";
        this.artifacts = artifacts;
        return this;
    }

    public InfinispanServerTestConfiguration enableJMX() {
        this.jmx = true;
        return this;
    }

    public InfinispanServerTestConfiguration mavenArtifacts(String ... artifacts) {
        assert (this.runMode == ServerRunMode.CONTAINER) : "Artifacts can be added only when runMode == CONTAINER";
        this.mavenArtifacts = artifacts;
        return this;
    }

    public String configurationFile() {
        return this.configurationFile;
    }

    public int numServers() {
        return this.numServers;
    }

    public ServerRunMode runMode() {
        return this.runMode;
    }

    public Properties properties() {
        return this.properties;
    }

    public JavaArchive[] artifacts() {
        return this.artifacts;
    }

    public boolean isJMXEnabled() {
        return this.jmx;
    }

    public String[] mavenArtifacts() {
        return this.mavenArtifacts;
    }
}

