/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.Self;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.test.Exceptions;
import org.infinispan.test.TestingUtil;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class InfinispanServerTestMethodRule
implements TestRule {
    private final InfinispanServerRule infinispanServerRule;
    private String methodName;
    private List<Closeable> resources;

    public InfinispanServerTestMethodRule(InfinispanServerRule infinispanServerRule) {
        this.infinispanServerRule = Objects.requireNonNull(infinispanServerRule);
    }

    public <T extends Closeable> T registerResource(T resource) {
        this.resources.add(resource);
        return resource;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                InfinispanServerTestMethodRule.this.before();
                try {
                    InfinispanServerTestMethodRule.this.methodName = description.getTestClass().getSimpleName() + "." + description.getMethodName();
                    base.evaluate();
                }
                finally {
                    InfinispanServerTestMethodRule.this.after();
                }
            }
        };
    }

    private void before() {
        this.resources = new ArrayList<Closeable>();
    }

    private void after() {
        if (this.resources != null) {
            this.resources.forEach(Util::close);
            this.resources.clear();
        }
    }

    public String getMethodName() {
        return this.getMethodName(null);
    }

    public String getMethodName(String qualifier) {
        String cacheName = "C" + this.methodName + (qualifier != null ? qualifier : "");
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] digest = sha1.digest(cacheName.getBytes(StandardCharsets.UTF_8));
            return Util.toHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public HotRod hotrod() {
        return new HotRod();
    }

    public Rest rest() {
        return new Rest();
    }

    public CounterManager getCounterManager() {
        RemoteCacheManager remoteCacheManager = this.registerResource(this.infinispanServerRule.newHotRodClient());
        return RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)remoteCacheManager);
    }

    public MemcachedClient getMemcachedClient() {
        return this.registerResource(this.infinispanServerRule.newMemcachedClient()).getClient();
    }

    public MBeanServerConnection getJmxConnection(int server) {
        return this.infinispanServerRule.getServerDriver().getJmxConnection(server);
    }

    public String addScript(RemoteCacheManager remoteCacheManager, String script) {
        RemoteCache scriptCache = remoteCacheManager.getCache("___script_cache");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(script);){
            scriptCache.put((Object)this.getMethodName(), (Object)TestingUtil.loadFileAsString((InputStream)in));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.getMethodName();
    }

    public class Rest
    extends Base<Rest> {
        RestClientConfigurationBuilder clientConfiguration;

        private Rest() {
            this.clientConfiguration = new RestClientConfigurationBuilder();
        }

        public Rest withClientConfiguration(RestClientConfigurationBuilder clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public RestClient get() {
            return InfinispanServerTestMethodRule.this.registerResource(InfinispanServerTestMethodRule.this.infinispanServerRule.newRestClient(this.clientConfiguration));
        }

        public RestClient create() {
            CompletionStage future;
            RestClient restClient = this.get();
            String name = InfinispanServerTestMethodRule.this.getMethodName(this.qualifier);
            if (this.serverConfiguration != null) {
                RestEntity configEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)this.serverConfiguration.toXMLString(name));
                future = restClient.cache(name).createWithConfiguration(configEntity, this.flags.toArray(new CacheContainerAdmin.AdminFlag[0]));
            } else {
                future = this.mode != null ? restClient.cache(name).createWithTemplate("org.infinispan." + this.mode.name(), this.flags.toArray(new CacheContainerAdmin.AdminFlag[0])) : restClient.cache(name).createWithTemplate("org.infinispan." + CacheMode.DIST_SYNC.name(), this.flags.toArray(new CacheContainerAdmin.AdminFlag[0]));
            }
            RestResponse response = (RestResponse)Exceptions.unchecked(() -> (RestResponse)future.toCompletableFuture().get(5L, TimeUnit.SECONDS));
            if (response.getStatus() != 200) {
                throw new RuntimeException("Could not obtain rest client = " + response.getStatus());
            }
            return restClient;
        }

        public Rest self() {
            return this;
        }
    }

    public class HotRod
    extends Base<HotRod> {
        ConfigurationBuilder clientConfiguration;

        private HotRod() {
            this.clientConfiguration = new ConfigurationBuilder();
        }

        public HotRod withClientConfiguration(ConfigurationBuilder clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public <K, V> RemoteCache<K, V> get() {
            RemoteCacheManager remoteCacheManager = InfinispanServerTestMethodRule.this.registerResource(InfinispanServerTestMethodRule.this.infinispanServerRule.newHotRodClient(this.clientConfiguration));
            String name = InfinispanServerTestMethodRule.this.getMethodName(this.qualifier);
            return remoteCacheManager.getCache(name);
        }

        public <K, V> RemoteCache<K, V> create() {
            RemoteCacheManager remoteCacheManager = InfinispanServerTestMethodRule.this.registerResource(InfinispanServerTestMethodRule.this.infinispanServerRule.newHotRodClient(this.clientConfiguration));
            String name = InfinispanServerTestMethodRule.this.getMethodName(this.qualifier);
            if (this.serverConfiguration != null) {
                return ((RemoteCacheManagerAdmin)remoteCacheManager.administration().withFlags(this.flags)).getOrCreateCache(name, this.serverConfiguration);
            }
            if (this.mode != null) {
                return ((RemoteCacheManagerAdmin)remoteCacheManager.administration().withFlags(this.flags)).getOrCreateCache(name, "org.infinispan." + this.mode.name());
            }
            return ((RemoteCacheManagerAdmin)remoteCacheManager.administration().withFlags(this.flags)).getOrCreateCache(name, "org.infinispan." + CacheMode.DIST_SYNC.name());
        }

        public HotRod self() {
            return this;
        }
    }

    public abstract class Base<S extends Base<S>>
    implements Self<S> {
        protected BasicConfiguration serverConfiguration = null;
        protected EnumSet<CacheContainerAdmin.AdminFlag> flags = EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class);
        protected CacheMode mode = null;
        protected String qualifier;

        public S withServerConfiguration(org.infinispan.configuration.cache.ConfigurationBuilder serverConfiguration) {
            if (this.mode != null) {
                throw new IllegalStateException("Cannot set server configuration and cache mode");
            }
            this.serverConfiguration = serverConfiguration.build();
            return (S)((Base)this.self());
        }

        public S withServerConfiguration(XMLStringConfiguration xmlConfiguration) {
            if (this.mode != null) {
                throw new IllegalStateException("Cannot set server configuration and cache mode");
            }
            this.serverConfiguration = xmlConfiguration;
            return (S)((Base)this.self());
        }

        public S withCacheMode(CacheMode mode) {
            if (this.serverConfiguration != null) {
                throw new IllegalStateException("Cannot set server configuration and cache mode");
            }
            this.mode = mode;
            return (S)((Base)this.self());
        }

        public S withQualifier(String qualifier) {
            this.qualifier = qualifier;
            return (S)((Base)this.self());
        }

        public S makeVolatile() {
            this.flags = EnumSet.of(CacheContainerAdmin.AdminFlag.VOLATILE);
            return (S)((Base)this.self());
        }
    }
}

