/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import javax.net.ssl.SSLHandshakeException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerRuleBuilder;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.infinispan.server.test.category.Security;
import org.infinispan.test.Exceptions;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={Security.class})
public class AuthenticationCertIT {
    @ClassRule
    public static InfinispanServerRule SERVERS = InfinispanServerRuleBuilder.config("configuration/AuthenticationServerTrustTest.xml").build();
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testTrustedCertificate() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        SERVERS.getServerDriver().applyTrustStore(builder, "ca");
        SERVERS.getServerDriver().applyKeyStore(builder, "admin");
        builder.security().authentication().saslMechanism("EXTERNAL").serverName("infinispan").realm("default");
        RemoteCache cache = ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withCacheMode(CacheMode.DIST_SYNC)).create();
        cache.put((Object)"k1", (Object)"v1");
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
    }

    @Test
    public void testUntrustedCertificate() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        SERVERS.getServerDriver().applyTrustStore(builder, "ca");
        SERVERS.getServerDriver().applyKeyStore(builder, "untrusted");
        builder.security().authentication().saslMechanism("EXTERNAL").serverName("infinispan").realm("default");
        Exceptions.expectException(TransportException.class, SSLHandshakeException.class, () -> ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withCacheMode(CacheMode.DIST_SYNC)).create());
    }
}

