/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Network;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.Version;
import org.infinispan.server.test.ContainerRemoteCacheManager;
import org.infinispan.server.test.ContainerUtil;
import org.infinispan.server.test.CountdownLatchLoggingConsumer;
import org.infinispan.server.test.InfinispanServerDriver;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.server.test.JBossLoggingConsumer;
import org.infinispan.test.Exceptions;
import org.jboss.logging.BasicLogger;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.utility.MountableFile;

public class ContainerInfinispanServerDriver
extends InfinispanServerDriver {
    private static final Log log = LogFactory.getLog(ContainerInfinispanServerDriver.class);
    private static final String STARTUP_MESSAGE_REGEX = ".*ISPN080001.*";
    private static final int STARTUP_TIMEOUT_SECONDS = 45;
    public static final String INFINISPAN_SERVER_HOME = "/opt/infinispan";
    public static final int JMX_PORT = 9999;
    private final List<GenericContainer> containers;
    private static final String EXTRA_LIBS = "org.infinispan.test.server.extension.libs";
    private String name;
    CountdownLatchLoggingConsumer latch;
    ImageFromDockerfile image;
    private File rootDir;
    private final boolean preferContainerExposedPorts = Boolean.getBoolean("org.infinispan.test.server.container.preferContainerExposedPorts");

    protected ContainerInfinispanServerDriver(InfinispanServerTestConfiguration configuration) {
        super(configuration, ContainerInfinispanServerDriver.getDockerBridgeAddress());
        this.containers = new ArrayList<GenericContainer>(configuration.numServers());
    }

    static InetAddress getDockerBridgeAddress() {
        DockerClient dockerClient = DockerClientFactory.instance().client();
        Network bridge = dockerClient.inspectNetworkCmd().withNetworkId("bridge").exec();
        String gateway = ((Network.Ipam.Config)bridge.getIpam().getConfig().get(0)).getGateway();
        return (InetAddress)Exceptions.unchecked(() -> InetAddress.getByName(gateway));
    }

    @Override
    protected void start(String name, File rootDir, String configurationFile) {
        this.name = name;
        this.rootDir = rootDir;
        ContainerInfinispanServerDriver.createServerHierarchy(rootDir);
        String baseImageName = System.getProperty("org.infinispan.test.server.baseImageName", "jboss/base-jdk:11");
        Path serverOutputDir = Paths.get(System.getProperty("server.output.dir"), new String[0]);
        ArrayList<String> args = new ArrayList<String>();
        args.add("bin/server.sh");
        args.add("-c");
        args.add(configurationFile);
        args.add("-b");
        args.add("SITE_LOCAL");
        args.add("-Djgroups.tcp.address=SITE_LOCAL");
        args.add("-Dinfinispan.cluster.name=" + name);
        args.add("-Dorg.infinispan.test.host.address=" + this.testHostAddress.getHostName());
        if (this.configuration.isJMXEnabled()) {
            args.add("-Dcom.sun.management.jmxremote.port=9999");
            args.add("-Dcom.sun.management.jmxremote.authenticate=false");
            args.add("-Dcom.sun.management.jmxremote.ssl=false");
        }
        Properties properties = new Properties();
        properties.setProperty("infinispan.server.config.path", Paths.get(INFINISPAN_SERVER_HOME, "conf").toString());
        properties.setProperty("infinispan.cluster.name", name);
        properties.setProperty("org.infinispan.test.host.address", this.testHostAddress.getHostName());
        this.configuration.properties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> args.add("-D" + k + "=" + StringPropertyReplacer.replaceProperties((String)((String)v), (Properties)properties))));
        this.image = (ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile().withFileFromPath("build", serverOutputDir)).withFileFromPath("test", rootDir.toPath())).withFileFromPath("target", serverOutputDir.getParent())).withFileFromPath("src", serverOutputDir.getParent().getParent().resolve("src"))).withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(baseImageName)).env("INFINISPAN_SERVER_HOME", INFINISPAN_SERVER_HOME)).env("INFINISPAN_VERSION", Version.getVersion())).label("name", "Infinispan Server")).label("version", Version.getVersion())).label("release", Version.getVersion())).label("architecture", "x86_64")).user("root")).copy("build", INFINISPAN_SERVER_HOME)).copy("test", "/opt/infinispan/server")).copy("src/test/resources/bin", "/opt/infinispan/bin")).run(new String[]{"chown", "-R", "jboss:jboss", INFINISPAN_SERVER_HOME})).workDir(INFINISPAN_SERVER_HOME)).user("jboss")).cmd(args.toArray(new String[0]))).expose(new Integer[]{11222, 11221, 7800, 43366, 9999})).build());
        this.latch = new CountdownLatchLoggingConsumer(this.configuration.numServers(), STARTUP_MESSAGE_REGEX);
        for (int i = 0; i < this.configuration.numServers(); ++i) {
            GenericContainer container = this.createContainer(i, rootDir);
            this.containers.add(i, container);
            log.infof("Starting container %s-%d", (Object)name, (Object)i);
            container.start();
        }
        Exceptions.unchecked(() -> this.latch.awaitStrict(45L, TimeUnit.SECONDS));
    }

    private GenericContainer createContainer(int i, File rootDir) {
        GenericContainer container = new GenericContainer((Future)this.image);
        File serverRoot = ContainerInfinispanServerDriver.createServerHierarchy(rootDir, Integer.toString(i), (hostDir, dir) -> {
            String containerDir = String.format("%s/server/%s", INFINISPAN_SERVER_HOME, dir);
            if ("lib".equals(dir)) {
                this.copyArtifactsToUserLibDir((File)hostDir);
            }
            container.withCopyFileToContainer(MountableFile.forHostPath((String)hostDir.getAbsolutePath()), containerDir);
            hostDir.setWritable(true, false);
        });
        container.withLogConsumer((Consumer)((Object)new JBossLoggingConsumer((BasicLogger)org.infinispan.util.logging.LogFactory.getLogger((String)this.name)).withPrefix(Integer.toString(i)))).withLogConsumer((Consumer)((Object)this.latch)).waitingFor((WaitStrategy)Wait.forListeningPort());
        return container;
    }

    private void copyArtifactsToUserLibDir(File libDir) {
        String[] artifacts;
        String propertyArtifacts = System.getProperty(EXTRA_LIBS);
        String[] stringArray = artifacts = propertyArtifacts != null ? propertyArtifacts.replaceAll("\\s+", "").split(",") : this.configuration.mavenArtifacts();
        if (artifacts != null && artifacts.length > 0) {
            MavenResolvedArtifact[] archives;
            MavenResolvedArtifact[] mavenResolvedArtifactArray = archives = (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(artifacts)).withoutTransitivity()).asResolvedArtifact();
            int n = mavenResolvedArtifactArray.length;
            for (int i = 0; i < n; ++i) {
                MavenResolvedArtifact archive = mavenResolvedArtifactArray[i];
                Exceptions.unchecked(() -> {
                    Path source = archive.asFile().toPath();
                    Files.copy(source, libDir.toPath().resolve(source.getFileName()), new CopyOption[0]);
                });
            }
        }
        if (this.configuration.archives() != null) {
            for (JavaArchive artifact : this.configuration.archives()) {
                File jar = libDir.toPath().resolve(artifact.getName()).toFile();
                jar.setWritable(true, false);
                ((ZipExporter)artifact.as(ZipExporter.class)).exportTo(jar, true);
            }
        }
    }

    @Override
    protected void stop() {
        for (int i = 0; i < this.containers.size(); ++i) {
            log.infof("Stopping container %s-%d", (Object)this.name, (Object)i);
            this.containers.get(i).stop();
            log.infof("Stopped container %s-%d", (Object)this.name, (Object)i);
        }
        this.containers.clear();
    }

    @Override
    public boolean isRunning(int server) {
        return this.containers.get(server).isRunning();
    }

    @Override
    public InetSocketAddress getServerSocket(int server, int port) {
        return new InetSocketAddress(this.getServerAddress(server), port);
    }

    @Override
    public InetAddress getServerAddress(int server) {
        GenericContainer container = this.containers.get(server);
        return (InetAddress)Exceptions.unchecked(() -> InetAddress.getByName(ContainerUtil.getIpAddressFromContainer(container)));
    }

    @Override
    public void pause(int server) {
        Container.ExecResult result = (Container.ExecResult)Exceptions.unchecked(() -> this.containers.get(server).execInContainer(new String[]{"/opt/infinispan/bin/pause.sh"}));
        System.out.printf("[%d] PAUSE %s\n", server, result);
    }

    @Override
    public void resume(int server) {
        Container.ExecResult result = (Container.ExecResult)Exceptions.unchecked(() -> this.containers.get(server).execInContainer(new String[]{"/opt/infinispan/bin/resume.sh"}));
        System.out.printf("[%d] RESUME %s\n", server, result);
    }

    @Override
    public void stop(int server) {
        this.containers.get(server).stop();
    }

    @Override
    public void kill(int server) {
        Exceptions.unchecked(() -> this.containers.get(server).execInContainer(new String[]{"/opt/infinispan/bin/kill.sh"}));
    }

    @Override
    public void restart(int server) {
        if (this.isRunning(server)) {
            throw new IllegalStateException("Server " + server + " is still running");
        }
        this.latch = new CountdownLatchLoggingConsumer(1, STARTUP_MESSAGE_REGEX);
        GenericContainer container = this.createContainer(server, this.rootDir);
        this.containers.set(server, container);
        log.infof("Restarting container %s-%d", (Object)this.name, (Object)server);
        container.start();
        Exceptions.unchecked(() -> this.latch.awaitStrict(45L, TimeUnit.SECONDS));
    }

    @Override
    public void restartCluster() {
        this.latch = new CountdownLatchLoggingConsumer(this.configuration.numServers(), STARTUP_MESSAGE_REGEX);
        for (int i = 0; i < this.configuration.numServers(); ++i) {
            GenericContainer container = this.createContainer(i, this.rootDir);
            this.containers.set(i, container);
            log.infof("Restarting container %s-%d", (Object)this.name, (Object)i);
            container.start();
        }
        Exceptions.unchecked(() -> this.latch.awaitStrict(45L, TimeUnit.SECONDS));
    }

    @Override
    public MBeanServerConnection getJmxConnection(int server) {
        return (MBeanServerConnection)Exceptions.unchecked(() -> {
            GenericContainer container = this.containers.get(server);
            ContainerNetwork network = (ContainerNetwork)container.getContainerInfo().getNetworkSettings().getNetworks().values().iterator().next();
            JMXServiceURL url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", network.getIpAddress(), 9999));
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url);
            return jmxConnector.getMBeanServerConnection();
        });
    }

    @Override
    public String getLog(int server) {
        GenericContainer container = this.containers.get(server);
        return container.getLogs();
    }

    @Override
    public RemoteCacheManager createRemoteCacheManager(ConfigurationBuilder builder) {
        if (this.preferContainerExposedPorts) {
            return new ContainerRemoteCacheManager(this.containers).wrap(builder);
        }
        return new RemoteCacheManager(builder.build());
    }
}

