/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.unit.configuration;

import java.io.File;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.server.logging.events.ServerEventLogger;
import org.infinispan.server.test.TestThreadTrackerRule;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.Exceptions;
import org.infinispan.test.MultiCacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ServerEventLoggerTest {
    @Rule
    public TestThreadTrackerRule tracker = new TestThreadTrackerRule();

    @Test
    public void testLocalServerEventLogging() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)ServerEventLoggerTest.amendGlobalConfiguration(new GlobalConfigurationBuilder()), (ConfigurationBuilder)new ConfigurationBuilder())){

            public void call() {
                this.cm.getCache();
                EventLogger eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)this.cm);
                Assert.assertTrue((String)eventLogger.getClass().getName(), (boolean)(eventLogger instanceof ServerEventLogger));
                eventLogger.info(EventLogCategory.CLUSTER, "message #1");
                eventLogger.info(EventLogCategory.TASKS, "message #2");
                eventLogger.warn(EventLogCategory.CLUSTER, "message #3");
                eventLogger.warn(EventLogCategory.TASKS, "message #4");
                List events = eventLogger.getEvents(Instant.now(), 10, Optional.of(EventLogCategory.CLUSTER), Optional.empty());
                Assert.assertEquals((long)2L, (long)events.size());
                Assert.assertEquals((Object)"message #3", (Object)((EventLog)events.get(0)).getMessage());
                Assert.assertEquals((Object)EventLogLevel.WARN, (Object)((EventLog)events.get(0)).getLevel());
                Assert.assertEquals((Object)"message #1", (Object)((EventLog)events.get(1)).getMessage());
                Assert.assertEquals((Object)EventLogLevel.INFO, (Object)((EventLog)events.get(1)).getLevel());
                events = eventLogger.getEvents(Instant.now(), 10, Optional.empty(), Optional.of(EventLogLevel.INFO));
                Assert.assertEquals((long)2L, (long)events.size());
                Assert.assertEquals((Object)"message #2", (Object)((EventLog)events.get(0)).getMessage());
                Assert.assertEquals((Object)EventLogCategory.TASKS, (Object)((EventLog)events.get(0)).getCategory());
                Assert.assertEquals((Object)"message #1", (Object)((EventLog)events.get(1)).getMessage());
                Assert.assertEquals((Object)EventLogCategory.CLUSTER, (Object)((EventLog)events.get(1)).getCategory());
            }
        });
    }

    @Test
    public void testClusteredServerEventLogging() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        TestingUtil.withCacheManagers((MultiCacheManagerCallable)new MultiCacheManagerCallable(new EmbeddedCacheManager[]{TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)ServerEventLoggerTest.amendGlobalConfiguration(GlobalConfigurationBuilder.defaultClusteredBuilder()), (ConfigurationBuilder)builder), TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)ServerEventLoggerTest.amendGlobalConfiguration(GlobalConfigurationBuilder.defaultClusteredBuilder()), (ConfigurationBuilder)builder), TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)ServerEventLoggerTest.amendGlobalConfiguration(GlobalConfigurationBuilder.defaultClusteredBuilder()), (ConfigurationBuilder)builder)}){

            public void call() {
                EventLogger eventLogger;
                int i;
                int msg = 1;
                TestingUtil.blockUntilViewReceived((Cache)this.cms[0].getCache(), (int)3);
                for (i = 0; i < this.cms.length; ++i) {
                    eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)this.cms[i]);
                    Assert.assertTrue((String)eventLogger.getClass().getName(), (boolean)(eventLogger instanceof ServerEventLogger));
                    eventLogger.info(EventLogCategory.SECURITY, "message #" + msg++);
                    eventLogger.warn(EventLogCategory.SECURITY, "message #" + msg++);
                    eventLogger.info(EventLogCategory.TASKS, "message #" + msg++);
                    eventLogger.warn(EventLogCategory.TASKS, "message #" + msg++);
                }
                for (i = 0; i < this.cms.length; ++i) {
                    eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)this.cms[i]);
                    List events = eventLogger.getEvents(Instant.now(), 10, Optional.of(EventLogCategory.TASKS), Optional.empty());
                    Assert.assertEquals((String)("Result count discrepancy on node " + i), (long)(2 * this.cms.length), (long)events.size());
                    for (EventLog event : events) {
                        Assert.assertEquals((Object)EventLogCategory.TASKS, (Object)event.getCategory());
                    }
                    events = eventLogger.getEvents(Instant.now(), 10, Optional.empty(), Optional.of(EventLogLevel.INFO));
                    for (EventLog event : events) {
                        Assert.assertEquals((Object)EventLogLevel.INFO, (Object)event.getLevel());
                    }
                }
            }
        });
    }

    @Test
    public void testLocalManagerNotStarted() {
        TestingUtil.withCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createCacheManager((boolean)false), cm -> Exceptions.expectException(IllegalLifecycleStateException.class, () -> EventLogManager.getEventLogger((EmbeddedCacheManager)cm)));
    }

    @Test
    public void testLocalServerEventLoggingPreloading() {
        GlobalConfigurationBuilder global = ServerEventLoggerTest.amendGlobalConfiguration(new GlobalConfigurationBuilder());
        global.globalState().enable();
        ServerEventLoggerTest.deleteGlobalPersistentState(global);
        TestingUtil.withCacheManager((EmbeddedCacheManager)this.startCacheManagerWithGlobalState(global), cm -> {
            EventLogger eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)cm);
            eventLogger.info(EventLogCategory.CLUSTER, "message #1");
        });
        TestingUtil.withCacheManager((EmbeddedCacheManager)this.startCacheManagerWithGlobalState(global), cm -> {
            EventLogger eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)cm);
            eventLogger.info(EventLogCategory.CLUSTER, "message #5");
        });
    }

    @Test
    public void testCacheContentCanBePassivated() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        GlobalConfigurationBuilder globalBuilder = ServerEventLoggerTest.amendGlobalConfiguration(GlobalConfigurationBuilder.defaultClusteredBuilder());
        globalBuilder.globalState().enable();
        ServerEventLoggerTest.deleteGlobalPersistentState(globalBuilder);
        TestingUtil.withCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalBuilder, (ConfigurationBuilder)builder), cm -> {
            EventLogger eventLogger = EventLogManager.getEventLogger((EmbeddedCacheManager)cm);
            eventLogger.info(EventLogCategory.CLUSTER, "message #1");
            Cache cache = cm.getCache("___event_log_cache");
            PassivationManager passivationManager = (PassivationManager)TestingUtil.extractComponent((Cache)cache, PassivationManager.class);
            CompletionStages.join((CompletionStage)passivationManager.passivateAllAsync());
            SingleFileStore sfs = (SingleFileStore)TestingUtil.getFirstWriter((Cache)cache);
            Assert.assertEquals((long)1L, (long)sfs.size());
        });
    }

    public EmbeddedCacheManager startCacheManagerWithGlobalState(GlobalConfigurationBuilder global) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)new ConfigurationBuilder());
        cm.start();
        return cm;
    }

    private static GlobalConfigurationBuilder amendGlobalConfiguration(GlobalConfigurationBuilder global) {
        String stateDirectory = TestingUtil.tmpDirectory((String)TestResourceTracker.getCurrentTestName());
        global.globalState().persistentLocation(stateDirectory);
        return global;
    }

    private static void deleteGlobalPersistentState(GlobalConfigurationBuilder global) {
        GlobalConfiguration globalCfg = global.build();
        new File(globalCfg.globalState().persistentLocation() + "/___event_log_cache.dat").delete();
    }
}

