/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.infinispan.commons.util.Version;
import org.infinispan.server.logging.Messages;
import org.infinispan.server.tool.Main;

public class UserTool
extends Main {
    public static final String DEFAULT_USERS_PROPERTIES_FILE = "users.properties";
    public static final String DEFAULT_GROUPS_PROPERTIES_FILE = "groups.properties";
    public static final String DEFAULT_REALM_NAME = "default";
    private String username = null;
    private String password = null;
    private String realm = "default";
    private String usersFileName = "users.properties";
    private String groupsFileName = "groups.properties";
    private List<String> addGroups = new ArrayList<String>();
    private boolean batchMode = false;

    public static void main(String[] args) {
        UserTool userTool = new UserTool();
        userTool.run(args);
    }

    @Override
    protected void handleArgumentCommand(String command, String parameter, Iterator<String> args) {
        switch (command) {
            case "-b": 
            case "--batch-mode": {
                this.batchMode = true;
                break;
            }
            case "-f": {
                parameter = args.next();
            }
            case "--users-file": {
                this.usersFileName = parameter;
                break;
            }
            case "-p": {
                parameter = args.next();
            }
            case "--password": {
                this.password = parameter;
                break;
            }
            case "-g": {
                parameter = args.next();
            }
            case "--groups": {
                for (String group : parameter.split(",")) {
                    this.addGroups.add(group);
                }
                break;
            }
            case "-w": {
                parameter = args.next();
            }
            case "--groups-file": {
                this.groupsFileName = parameter;
                break;
            }
            case "-r": {
                parameter = args.next();
            }
            case "--realm": {
                this.realm = parameter;
                break;
            }
            case "-s": {
                parameter = args.next();
            }
            case "--server-root": {
                this.serverRoot = new File(parameter);
                break;
            }
            case "-u": {
                parameter = args.next();
            }
            case "--user": {
                this.username = parameter;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    protected void runInternal() {
        FileWriter writer;
        while (this.username == null || this.username.isEmpty()) {
            this.username = System.console().readLine(Messages.MSG.userToolUsername(), new Object[0]);
        }
        File confDir = new File(this.serverRoot, "conf");
        Properties users = new Properties();
        File usersFile = new File(confDir, this.usersFileName);
        if (usersFile.exists()) {
            try (FileReader reader = new FileReader(usersFile);){
                users.load(reader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Properties groups = new Properties();
        File groupsFile = new File(confDir, this.groupsFileName);
        if (groupsFile.exists()) {
            try (FileReader reader = new FileReader(groupsFile);){
                groups.load(reader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.batchMode && users.containsKey(this.username)) {
            String answer;
            while (!"Y".equalsIgnoreCase(answer = System.console().readLine(Messages.MSG.userToolUserExists(this.username), new Object[0])) && !"N".equalsIgnoreCase(answer)) {
            }
            if ("N".equalsIgnoreCase(answer)) {
                this.exit(0);
            }
        }
        if (this.password == null) {
            if (!this.batchMode) {
                while (true) {
                    if (this.password == null || this.password.isEmpty()) {
                        this.password = new String(System.console().readPassword(Messages.MSG.userToolPassword(), new Object[0]));
                        continue;
                    }
                    String confirm = new String(System.console().readPassword(Messages.MSG.userToolPasswordConfirm(), new Object[0]));
                    if (!this.password.equals(confirm)) {
                        this.password = null;
                    }
                    if (this.password != null) break;
                }
            } else {
                this.stdErr.println(Messages.MSG.userToolNoPassword(this.username));
                this.exit(1);
            }
        }
        users.put(this.username, UserTool.hashPassword(this.username, this.password, this.realm));
        groups.put(this.username, this.addGroups.stream().collect(Collectors.joining(",")));
        try {
            writer = new FileWriter(usersFile);
            try {
                users.store(writer, "$REALM_NAME=" + this.realm + "$");
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            writer = new FileWriter(groupsFile);
            try {
                groups.store(writer, null);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String hashPassword(String username, String password, String realm) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] hashed = md5.digest((username + ":" + realm + ":" + password).getBytes(StandardCharsets.UTF_8));
            return UserTool.toHex(hashed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    @Override
    public void help(PrintStream out) {
        out.printf("Usage:\n", new Object[0]);
        out.printf("  -u, --user=<name>                  %s\n", Messages.MSG.userToolHelpUser());
        out.printf("  -p, --password=<password>          %s\n", Messages.MSG.userToolHelpPassword());
        out.printf("  -g, --groups=<group1[,group2...]>  %s\n", Messages.MSG.userToolHelpGroups());
        out.printf("  -f, --users-file=<file>            %s\n", Messages.MSG.userToolHelpUsersFile(DEFAULT_USERS_PROPERTIES_FILE));
        out.printf("  -w, --groups-file=<file>           %s\n", Messages.MSG.userToolHelpGroupsFile(DEFAULT_GROUPS_PROPERTIES_FILE));
        out.printf("  -r, --realm=<realm>                %s\n", Messages.MSG.userToolHelpRealm(DEFAULT_REALM_NAME));
        out.printf("  -s, --server-root=<path>           %s\n", Messages.MSG.toolHelpServerRoot("server"));
        out.printf("  -b, --batch-mode                   %s\n", Messages.MSG.userToolHelpBatchMode());
        out.printf("  -h, --help                         %s\n", Messages.MSG.toolHelpHelp());
        out.printf("  -v, --version                      %s\n", Messages.MSG.toolHelpVersion());
    }

    @Override
    public void version(PrintStream out) {
        out.printf("%s User Tool %s (%s)\n", Version.getBrandName(), Version.getVersion(), Version.getCodename());
        out.println("Copyright (C) Red Hat Inc. and/or its affiliates and other contributors");
        out.println("License Apache License, v. 2.0. http://www.apache.org/licenses/LICENSE-2.0");
    }
}

