/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.tasks;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.server.tasks.DistributedServerTask;
import org.infinispan.server.tasks.SecurityActions;
import org.infinispan.server.tasks.ServerTaskEngine;
import org.infinispan.server.tasks.ServerTaskRunner;
import org.infinispan.tasks.TaskContext;
import org.infinispan.util.function.TriConsumer;

public class DistributedServerTaskRunner
implements ServerTaskRunner {
    private final ServerTaskEngine serverTaskEngine;

    public DistributedServerTaskRunner(ServerTaskEngine serverTaskEngine) {
        this.serverTaskEngine = serverTaskEngine;
    }

    @Override
    public <T> CompletableFuture<T> execute(String taskName, TaskContext context) {
        Cache masterCacheNode = (Cache)context.getCache().get();
        ClusterExecutor clusterExecutor = SecurityActions.getClusterExecutor(context.getCacheManager());
        ArrayList results = new ArrayList();
        TriConsumer triConsumer = (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
            DistributedServerTaskRunner distributedServerTaskRunner = this;
            synchronized (distributedServerTaskRunner) {
                results.add(v);
            }
        };
        CompletableFuture future = clusterExecutor.submitConsumer(new DistributedServerTask(masterCacheNode.getName(), taskName, context.getParameters()), triConsumer);
        return future.thenApply(ignore -> results);
    }
}

