/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.loader;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.LinkedHashSet;

public class Loader {
    public static final String INFINISPAN_SERVER_HOME_PATH = "infinispan.server.home.path";
    public static final String INFINISPAN_SERVER_ROOT_PATH = "infinispan.server.root.path";
    public static final String DEFAULT_SERVER_ROOT_DIR = "server";

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("You must specify a classname to launch");
        }
        String home = System.getProperty(INFINISPAN_SERVER_HOME_PATH, System.getProperty("user.dir"));
        ClassLoader bootClassLoader = Loader.class.getClassLoader();
        ClassLoader serverClassLoader = Loader.classLoaderFromPath(Paths.get(home, "lib"), bootClassLoader);
        String root = System.getProperty(INFINISPAN_SERVER_ROOT_PATH, Paths.get(home, DEFAULT_SERVER_ROOT_DIR).toString());
        ClassLoader rootClassLoader = Loader.classLoaderFromPath(Paths.get(root, "lib"), serverClassLoader);
        Thread.currentThread().setContextClassLoader(rootClassLoader);
        try {
            Class<?> mainClass = rootClassLoader.loadClass(args[0]);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            String[] mainArgs = new String[args.length - 1];
            System.arraycopy(args, 1, mainArgs, 0, mainArgs.length);
            mainMethod.invoke(null, new Object[]{mainArgs});
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public static ClassLoader classLoaderFromPath(Path path, ClassLoader parent) {
        try {
            LinkedHashSet jars = new LinkedHashSet();
            Files.walk(path, new FileVisitOption[0]).filter(f -> f.toString().endsWith(".jar")).forEach(jar -> {
                try {
                    jars.add(jar.toUri().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            });
            URL[] array = jars.toArray(new URL[jars.size()]);
            return AccessController.doPrivileged(() -> {
                if (parent == null) {
                    return new URLClassLoader(array);
                }
                return new URLClassLoader(array, parent);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

