/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestMetricsClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RestMetricsResource {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testOpenMetrics() {
        RestMetricsClient metricsClient = this.SERVER_TEST.rest().create().metrics();
        RestResponse response = (RestResponse)Common.sync(metricsClient.metrics(true));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)response.contentType());
        String metricsText = response.getBody();
        String metricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_statistics_stores";
        Assert.assertTrue((boolean)metricsText.contains("# TYPE vendor_" + metricName + " gauge\n"));
        response = (RestResponse)Common.sync(metricsClient.metrics("vendor/" + metricName, true));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        metricsText = response.getBody();
        Assert.assertTrue((boolean)metricsText.contains("# TYPE vendor_" + metricName + " gauge\n"));
    }

    @Test
    public void testBaseAndVendorMetrics() throws Exception {
        RestMetricsClient metricsClient = this.SERVER_TEST.rest().create().metrics();
        RestResponse response = (RestResponse)Common.sync(metricsClient.metrics("base/classloader.loadedClasses.count"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JsonNode loadedClassesCountNode = this.mapper.readTree(response.getBody());
        Assert.assertTrue((boolean)loadedClassesCountNode.hasNonNull("classloader.loadedClasses.count"));
        int loadedClassesCount = loadedClassesCountNode.get("classloader.loadedClasses.count").asInt();
        Assert.assertTrue((loadedClassesCount > 0 ? 1 : 0) != 0);
        response = (RestResponse)Common.sync(metricsClient.metrics("vendor/memoryPool.Metaspace.usage"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JsonNode memoryPoolMetaspaceUsageNode = this.mapper.readTree(response.getBody());
        Assert.assertTrue((boolean)memoryPoolMetaspaceUsageNode.hasNonNull("memoryPool.Metaspace.usage"));
        int metaspaceUsage = memoryPoolMetaspaceUsageNode.get("memoryPool.Metaspace.usage").asInt();
        Assert.assertTrue((metaspaceUsage > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMicroprofileMetrics() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestMetricsClient metricsClient = client.metrics();
        String metricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_statistics_stores";
        RestResponse response = (RestResponse)Common.sync(metricsClient.metrics());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)response.contentType());
        String metricsJson = response.getBody();
        JsonNode node = this.mapper.readTree(metricsJson);
        Assert.assertNotNull((Object)node.get("base"));
        Assert.assertNotNull((Object)node.get("vendor"));
        Assert.assertNotNull((Object)node.get("application"));
        Assert.assertTrue((boolean)metricsJson.contains(metricName));
        response = (RestResponse)Common.sync(metricsClient.metrics("vendor/" + metricName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        long totalStoresBefore = RestMetricsResource.streamNodeFields(this.mapper.readTree(response.getBody())).map(e -> ((JsonNode)e.getValue()).asLong()).reduce(0L, Long::sum);
        Assert.assertEquals((long)0L, (long)totalStoresBefore);
        RestCacheClient cache = client.cache(this.SERVER_TEST.getMethodName());
        int NUM_PUTS = 10;
        for (int i = 0; i < NUM_PUTS; ++i) {
            RestResponse putResp = (RestResponse)Common.sync(cache.put("k" + i, "v" + i));
            Assert.assertEquals((long)204L, (long)putResp.getStatus());
        }
        response = (RestResponse)Common.sync(metricsClient.metrics("vendor/" + metricName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String metricJson = response.getBody();
        long totalStoresAfter = RestMetricsResource.streamNodeFields(this.mapper.readTree(metricJson)).map(e -> ((JsonNode)e.getValue()).asLong()).reduce(0L, Long::sum);
        Assert.assertEquals((long)NUM_PUTS, (long)totalStoresAfter);
    }

    @Test
    public void testMicroprofileTimerMetrics() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestMetricsClient metricsClient = client.metrics();
        String metricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_statistics_store_times";
        RestResponse response = (RestResponse)Common.sync(metricsClient.metrics("vendor/" + metricName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)response.contentType());
        long meanStoreTimesBefore = RestMetricsResource.streamNodeFields(this.mapper.readTree(response.getBody()).get(metricName)).filter(e -> ((String)e.getKey()).startsWith("mean;")).map(e -> ((JsonNode)e.getValue()).asLong()).reduce(0L, Long::sum);
        Assert.assertEquals((long)0L, (long)meanStoreTimesBefore);
        RestCacheClient cache = client.cache(this.SERVER_TEST.getMethodName());
        int NUM_PUTS = 10;
        for (int i = 0; i < NUM_PUTS; ++i) {
            RestResponse putResp = (RestResponse)Common.sync(cache.put("k" + i, "v" + i));
            Assert.assertEquals((long)204L, (long)putResp.getStatus());
        }
        response = (RestResponse)Common.sync(metricsClient.metrics("vendor/" + metricName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        long meanStoreTimesAfter = RestMetricsResource.streamNodeFields(this.mapper.readTree(response.getBody()).get(metricName)).filter(e -> ((String)e.getKey()).startsWith("mean;")).map(e -> ((JsonNode)e.getValue()).asLong()).reduce(0L, Long::sum);
        Assert.assertTrue((meanStoreTimesAfter > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testMicroprofileMetricsMetadata() throws Exception {
        RestMetricsClient metricsClient = this.SERVER_TEST.rest().create().metrics();
        RestResponse response = (RestResponse)Common.sync(metricsClient.metricsMetadata());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)response.contentType());
        String metricsMetadataJson = response.getBody();
        String metricName = "cache_manager_default_cache_" + this.SERVER_TEST.getMethodName() + "_statistics_stores";
        Assert.assertTrue((boolean)metricsMetadataJson.contains(metricName));
        response = (RestResponse)Common.sync(metricsClient.metricsMetadata("vendor/" + metricName));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JsonNode node = this.mapper.readTree(response.getBody());
        Assert.assertNotNull((Object)node.get(metricName));
        Assert.assertEquals((Object)"gauge", (Object)node.get(metricName).get("type").asText());
        Assert.assertEquals((Object)"stores", (Object)node.get(metricName).get("displayName").asText());
    }

    private static Stream<Map.Entry<String, JsonNode>> streamNodeFields(JsonNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Input node cannot be null");
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(node.fields(), 1024), false);
    }
}

