/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import java.util.Properties;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.server.test.ServerRunMode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class InfinispanServerRuleBuilder {
    private final String configurationFile;
    private String[] mavenArtifacts;
    private int numServers = 2;
    private Properties properties = new Properties();
    private ServerRunMode runMode = ServerRunMode.DEFAULT;
    private JavaArchive[] archives;
    private boolean jmx;

    public static InfinispanServerRuleBuilder config(String configurationFile) {
        return new InfinispanServerRuleBuilder(configurationFile);
    }

    private InfinispanServerRuleBuilder(String configurationFile) {
        this.configurationFile = configurationFile;
    }

    public InfinispanServerRuleBuilder mavenArtifacts(String ... mavenArtifacts) {
        this.mavenArtifacts = mavenArtifacts;
        return this;
    }

    public InfinispanServerRuleBuilder numServers(int numServers) {
        this.numServers = numServers;
        return this;
    }

    public InfinispanServerRuleBuilder runMode(ServerRunMode serverRunMode) {
        this.runMode = serverRunMode;
        return this;
    }

    public InfinispanServerRuleBuilder artifacts(JavaArchive ... archives) {
        this.archives = archives;
        return this;
    }

    public InfinispanServerRuleBuilder property(String name, String value) {
        this.properties.setProperty(name, value);
        return this;
    }

    public InfinispanServerRuleBuilder enableJMX() {
        this.jmx = true;
        return this;
    }

    public InfinispanServerRule build() {
        InfinispanServerTestConfiguration configuration = new InfinispanServerTestConfiguration(this.configurationFile, this.numServers, this.runMode, this.properties, this.mavenArtifacts, this.archives, this.jmx);
        return new InfinispanServerRule(configuration);
    }
}

