/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.persistence;

import java.io.InputStream;
import java.util.Properties;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.persistence.Database;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class DatabaseServerRule
implements TestRule {
    public static final String DATABASES = "org.infinispan.test.server.jdbc.databases";
    private final InfinispanServerRule infinispanServerRule;
    public Database database;

    public DatabaseServerRule(InfinispanServerRule infinispanServerRule) {
        this.infinispanServerRule = infinispanServerRule;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                DatabaseServerRule.this.before();
                try {
                    base.evaluate();
                }
                finally {
                    DatabaseServerRule.this.after();
                }
            }
        };
    }

    private void before() {
        if (this.infinispanServerRule.getServerDriver().getStatus() != ComponentStatus.RUNNING) {
            throw new IllegalStateException("Infinispan Server should be running");
        }
    }

    private void after() {
        this.database.stop();
    }

    public void setDatabaseType(String databaseType) {
        if (this.database != null) {
            if (this.database.getType().equals(databaseType)) {
                return;
            }
            this.database.stop();
        }
        this.database = this.initDatabase(databaseType);
        this.database.start();
    }

    public Database getDatabase() {
        return this.database;
    }

    private Database initDatabase(String databaseType) {
        Database database;
        block8: {
            String filename = String.format("/database/%s.properties", databaseType);
            InputStream inputStream = this.getClass().getResourceAsStream(filename);
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                database = Database.fromProperties(databaseType, properties);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return database;
    }

    public static String[] getDatabaseTypes(String ... defaults) {
        String property = System.getProperty(DATABASES);
        if (property != null) {
            return property.split(",");
        }
        return defaults;
    }
}

