/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import java.io.IOException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.rest.helper.RestResponses;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class RestRouter {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Test
    public void testRestRouting() {
        Function<String, RestClientConfiguration> cfgFromCtx = c -> new RestClientConfigurationBuilder().contextPath(c).build();
        try (RestClient restCtx = RestClient.forConfiguration((RestClientConfiguration)cfgFromCtx.apply("/rest"));
             RestClient invalidCtx = RestClient.forConfiguration((RestClientConfiguration)cfgFromCtx.apply("/invalid"));
             RestClient emptyCtx = RestClient.forConfiguration((RestClientConfiguration)cfgFromCtx.apply("/"));){
            String body = RestResponses.responseBody((CompletionStage)restCtx.server().info());
            Assert.assertTrue((boolean)body.contains("version"));
            RestResponses.assertStatus((int)404, (CompletionStage)emptyCtx.server().info());
            RestResponses.assertStatus((int)404, (CompletionStage)invalidCtx.server().info());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

