/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.functional;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.functional.ClusteredIT;
import org.infinispan.server.security.Common;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.testcontainers.shaded.com.google.common.collect.Sets;

public class RestServerResource {
    @ClassRule
    public static InfinispanServerRule SERVERS = ClusteredIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testConfig() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse restResponse = (RestResponse)Common.sync(client.server().configuration());
        JsonNode configNode = this.mapper.readTree(restResponse.getBody());
        JsonNode server = configNode.get("server");
        JsonNode interfaces = server.get("interfaces");
        JsonNode security = server.get("security");
        JsonNode endpoints = server.get("endpoints");
        Assert.assertEquals((Object)"127.0.0.1", (Object)interfaces.get("interface").get("inet-address").get("value").asText());
        Assert.assertEquals((Object)"default", (Object)security.get("security-realms").get("security-realm").get("name").asText());
        Assert.assertEquals((Object)"hotrod", (Object)endpoints.get("hotrod-connector").get("name").asText());
        Assert.assertEquals((Object)"rest", (Object)endpoints.get("rest-connector").get("name").asText());
        Assert.assertEquals((Object)"memcachedCache", (Object)endpoints.get("memcached-connector").get("cache").asText());
    }

    @Test
    public void testThreads() {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse restResponse = (RestResponse)Common.sync(client.server().threads());
        String dump = restResponse.getBody();
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)restResponse.contentType());
        Assert.assertTrue((boolean)dump.contains("state=RUNNABLE"));
    }

    @Test
    public void testInfo() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse restResponse = (RestResponse)Common.sync(client.server().info());
        String body = restResponse.getBody();
        JsonNode infoNode = this.mapper.readTree(body);
        Assert.assertNotNull((Object)infoNode.get("version"));
    }

    @Test
    public void testMemory() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse restResponse = (RestResponse)Common.sync(client.server().memory());
        JsonNode infoNode = this.mapper.readTree(restResponse.getBody());
        JsonNode memory = infoNode.get("heap");
        Assert.assertTrue((memory.get("init").asInt() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((memory.get("used").asInt() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((memory.get("committed").asInt() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEnv() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse restResponse = (RestResponse)Common.sync(client.server().env());
        JsonNode infoNode = this.mapper.readTree(restResponse.getBody());
        JsonNode osVersion = infoNode.get("os.version");
        Assert.assertEquals((Object)System.getProperty("os.version"), (Object)osVersion.asText());
    }

    @Test
    public void testCacheManagerNames() throws Exception {
        RestClient client = this.SERVER_TEST.rest().create();
        RestResponse restResponse = (RestResponse)Common.sync(client.cacheManagers());
        ArrayNode cacheManagers = (ArrayNode)this.mapper.readTree(restResponse.getBody());
        Set cmNames = StreamSupport.stream(cacheManagers.spliterator(), false).map(JsonNode::asText).collect(Collectors.toSet());
        Assert.assertEquals(cmNames, (Object)Sets.newHashSet((Object[])new String[]{"default"}));
    }
}

