/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.persistence;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.server.persistence.PersistenceIT;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.infinispan.server.test.category.Persistence;
import org.infinispan.server.test.persistence.DatabaseServerRule;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={Persistence.class})
@RunWith(value=Parameterized.class)
public class PooledConnectionOperations {
    @ClassRule
    public static InfinispanServerRule SERVERS = PersistenceIT.SERVERS;
    @ClassRule
    public static DatabaseServerRule DATABASE = new DatabaseServerRule(SERVERS);
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        String[] databaseTypes = DatabaseServerRule.getDatabaseTypes("h2", "mysql", "postgres");
        ArrayList<Object[]> params = new ArrayList<Object[]>(databaseTypes.length);
        for (String databaseType : databaseTypes) {
            params.add(new Object[]{databaseType});
        }
        return params;
    }

    public PooledConnectionOperations(String databaseType) {
        DATABASE.setDatabaseType(databaseType);
    }

    private ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).fetchPersistentState(false)).ignoreModifications(false)).purgeOnStartup(false)).shared(false)).table().dropOnExit(true)).createOnStart(true)).tableNamePrefix("TBL")).idColumnName("ID")).idColumnType(DATABASE.getDatabase().getIdColumType())).dataColumnName("DATA")).dataColumnType(DATABASE.getDatabase().getDataColumnType())).timestampColumnName("TS")).timestampColumnType(DATABASE.getDatabase().getTimeStampColumnType())).segmentColumnName("S")).segmentColumnType(DATABASE.getDatabase().getSegmentColumnType())).connectionPool().connectionUrl(DATABASE.getDatabase().jdbcUrl()).username(DATABASE.getDatabase().username()).password(DATABASE.getDatabase().password()).driverClass(DATABASE.getDatabase().driverClassName());
        return builder;
    }

    @Test
    public void testTwoCachesSameCacheStore() {
        RemoteCache cache1 = ((InfinispanServerTestMethodRule.HotRod)((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withServerConfiguration(this.createConfigurationBuilder())).withQualifier("1")).create();
        RemoteCache cache2 = ((InfinispanServerTestMethodRule.HotRod)((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withServerConfiguration(this.createConfigurationBuilder())).withQualifier("2")).create();
        cache1.put((Object)"k1", (Object)"v1");
        String firstK1 = (String)cache1.get((Object)"k1");
        Assert.assertEquals((Object)"v1", (Object)firstK1);
        Assert.assertNull((Object)cache2.get((Object)"k1"));
        cache2.put((Object)"k2", (Object)"v2");
        Assert.assertEquals((Object)"v2", (Object)cache2.get((Object)"k2"));
        Assert.assertNull((Object)cache1.get((Object)"k2"));
        this.assertCleanCacheAndStore(cache1);
        this.assertCleanCacheAndStore(cache2);
    }

    @Test
    public void testPutGetRemove() {
        RemoteCache cache = ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withServerConfiguration(this.createConfigurationBuilder())).create();
        cache.put((Object)"k1", (Object)"v1");
        cache.put((Object)"k2", (Object)"v2");
        Assert.assertNotNull((Object)cache.get((Object)"k1"));
        Assert.assertNotNull((Object)cache.get((Object)"k2"));
        cache.stop();
        cache.start();
        Assert.assertNotNull((Object)cache.get((Object)"k1"));
        Assert.assertNotNull((Object)cache.get((Object)"k2"));
        Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
        Assert.assertEquals((Object)"v2", (Object)cache.get((Object)"k2"));
        cache.remove((Object)"k1");
        Assert.assertNull((Object)cache.get((Object)"k1"));
    }

    protected void assertCleanCacheAndStore(RemoteCache cache) {
        cache.clear();
        Assert.assertEquals((long)0L, (long)cache.size());
    }
}

