/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.authentication;

import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.security.Common;
import org.infinispan.server.security.authentication.AuthenticationIT;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestMethodRule;
import org.infinispan.server.test.category.Security;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={Security.class})
public class HotRodAuthentication {
    @ClassRule
    public static InfinispanServerRule SERVERS = AuthenticationIT.SERVERS;
    @Rule
    public InfinispanServerTestMethodRule SERVER_TEST = new InfinispanServerTestMethodRule(SERVERS);
    private final String mechanism;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Common.SASL_MECHS;
    }

    public HotRodAuthentication(String mechanism) {
        this.mechanism = mechanism;
    }

    @Test
    public void testHotRodReadWrite() {
        block3: {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            if (!this.mechanism.isEmpty()) {
                builder.security().authentication().saslMechanism(this.mechanism).serverName("infinispan").realm("default").username("all_user").password("all");
            }
            try {
                RemoteCache cache = ((InfinispanServerTestMethodRule.HotRod)this.SERVER_TEST.hotrod().withClientConfiguration(builder).withCacheMode(CacheMode.DIST_SYNC)).create();
                cache.put((Object)"k1", (Object)"v1");
                Assert.assertEquals((long)1L, (long)cache.size());
                Assert.assertEquals((Object)"v1", (Object)cache.get((Object)"k1"));
            }
            catch (HotRodClientException e) {
                if (this.mechanism.isEmpty()) break block3;
                throw e;
            }
        }
    }
}

