/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.server.test.ContainerUtil;
import org.testcontainers.containers.GenericContainer;

public class ContainerRemoteCacheManager {
    private final List<GenericContainer> containers;

    public ContainerRemoteCacheManager(List<GenericContainer> containers) {
        this.containers = containers;
    }

    public RemoteCacheManager wrap(ConfigurationBuilder builder) {
        return new RemoteCacheManager(builder.build()){

            public ChannelFactory createChannelFactory() {
                return new ChannelFactory(){

                    protected Collection<SocketAddress> updateTopologyInfo(byte[] cacheName, Collection<SocketAddress> newServers, boolean quiet) {
                        ArrayList<InetSocketAddress> localHostServers = new ArrayList<InetSocketAddress>();
                        for (SocketAddress address : newServers) {
                            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                            GenericContainer container = ContainerRemoteCacheManager.this.getGeneriContainerBy(inetSocketAddress);
                            localHostServers.add(new InetSocketAddress("localhost", (int)container.getMappedPort(inetSocketAddress.getPort())));
                        }
                        return super.updateTopologyInfo(cacheName, localHostServers, quiet);
                    }
                };
            }
        };
    }

    private GenericContainer getGeneriContainerBy(InetSocketAddress inetSocketAddress) {
        for (GenericContainer container : this.containers) {
            String hostName = ContainerUtil.getIpAddressFromContainer(container);
            if (!inetSocketAddress.getHostName().equals(hostName)) continue;
            return container;
        }
        throw new IllegalStateException();
    }
}

