/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.management.MBeanServerConnection;
import javax.security.auth.x500.X500Principal;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.util.Util;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.test.InfinispanServerRule;
import org.infinispan.server.test.InfinispanServerTestConfiguration;
import org.infinispan.test.Exceptions;
import org.infinispan.test.TestingUtil;
import org.wildfly.security.x500.cert.BasicConstraintsExtension;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public abstract class InfinispanServerDriver {
    public static final String TEST_HOST_ADDRESS = "org.infinispan.test.host.address";
    public static final String BASE_DN = "CN=%s,OU=Infinispan,O=JBoss,L=Red Hat";
    public static final String KEY_PASSWORD = "secret";
    protected final InfinispanServerTestConfiguration configuration;
    protected final InetAddress testHostAddress;
    private File rootDir;
    private File confDir;
    private ComponentStatus status;
    private AtomicLong certSerial = new AtomicLong(1L);

    protected InfinispanServerDriver(InfinispanServerTestConfiguration configuration, InetAddress testHostAddress) {
        this.configuration = configuration;
        this.testHostAddress = testHostAddress;
        this.status = ComponentStatus.INSTANTIATED;
    }

    public ComponentStatus getStatus() {
        return this.status;
    }

    protected abstract void start(String var1, File var2, String var3);

    protected abstract void stop();

    public void prepare(String name) {
        String testDir = TestingUtil.tmpDirectory((String)name);
        Util.recursiveFileRemove((String)testDir);
        this.rootDir = new File(testDir);
        this.confDir = new File(this.rootDir, "conf");
        if (!this.confDir.mkdirs()) {
            throw new RuntimeException("Failed to create server configuration directory " + this.confDir);
        }
        URL configurationFileURL = new File(this.configuration.configurationFile()).isAbsolute() ? (URL)Exceptions.unchecked(() -> new File(this.configuration.configurationFile()).toURI().toURL()) : this.getClass().getClassLoader().getResource(this.configuration.configurationFile());
        if (configurationFileURL == null) {
            throw new RuntimeException("Cannot find test configuration file: " + this.configuration.configurationFile());
        }
        try {
            Path configurationFilePath = Paths.get(configurationFileURL.toURI());
            Util.recursiveDirectoryCopy((Path)configurationFilePath.getParent(), (Path)this.confDir.toPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.createUserFile("default", true);
        this.createKeyStores();
    }

    public void start(String name) {
        InfinispanServerRule.log.infof("Starting server %s", (Object)name);
        this.start(name, this.rootDir, new File(this.configuration.configurationFile()).getName());
        InfinispanServerRule.log.infof("Started server %s", (Object)name);
        this.status = ComponentStatus.RUNNING;
    }

    public final void stop(String name) {
        this.status = ComponentStatus.STOPPING;
        InfinispanServerRule.log.infof("Stopping server %s", (Object)name);
        this.stop();
        InfinispanServerRule.log.infof("Stopped server %s", (Object)name);
        this.status = ComponentStatus.TERMINATED;
    }

    protected static File createServerHierarchy(File baseDir) {
        return InfinispanServerDriver.createServerHierarchy(baseDir, null, null);
    }

    protected static File createServerHierarchy(File baseDir, String name) {
        return InfinispanServerDriver.createServerHierarchy(baseDir, name, null);
    }

    protected static File createServerHierarchy(File baseDir, String name, BiConsumer<File, String> consumer) {
        File rootDir = name == null ? baseDir : new File(baseDir, name);
        for (String dir : Arrays.asList("data", "log", "lib")) {
            File d = new File(rootDir, dir);
            if (!d.mkdirs()) {
                throw new IllegalStateException("Unable to create directory " + d);
            }
            if (consumer == null) continue;
            consumer.accept(d, dir);
        }
        return rootDir;
    }

    protected void createUserFile(String realm, boolean plain) {
        File userFile = new File(this.confDir, "users.properties");
        File groupsFile = new File(this.confDir, "groups.properties");
        try (PrintWriter uw = new PrintWriter(userFile);
             PrintWriter gw = new PrintWriter(groupsFile);){
            uw.printf("#$REALM_NAME=%s$\n", realm);
            for (AuthorizationPermission permission : AuthorizationPermission.values()) {
                String password;
                String name = permission.name().toLowerCase();
                if (plain) {
                    password = name;
                } else {
                    try {
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        password = Util.toHexString((byte[])md.digest(String.format("%s:%s:%s", name, realm, name).getBytes(StandardCharsets.UTF_8)));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException(e);
                    }
                }
                uw.printf("%s_user=%s\n", name, password);
                gw.printf("%s_user=%s\n", name, name);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getCertificateFile(String name) {
        return new File(this.confDir, name + ".pfx");
    }

    public File getConfDir() {
        return this.confDir;
    }

    protected void createKeyStores() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey signingKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            X500Principal CA_DN = InfinispanServerDriver.dn("CA");
            KeyStore trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null);
            SelfSignedX509CertificateAndSigningKey ca = this.createSelfSignedCertificate(CA_DN, true, "ca");
            trustStore.setCertificateEntry("ca", ca.getSelfSignedCertificate());
            this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, "server", trustStore);
            this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, "admin", trustStore);
            this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, "supervisor", trustStore);
            this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, "writer", trustStore);
            this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, "reader", trustStore);
            try (FileOutputStream os = new FileOutputStream(this.getCertificateFile("trust"));){
                trustStore.store(os, KEY_PASSWORD.toCharArray());
            }
            this.createSelfSignedCertificate(CA_DN, true, "untrusted");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static X500Principal dn(String cn) {
        return new X500Principal(String.format(BASE_DN, cn));
    }

    protected SelfSignedX509CertificateAndSigningKey createSelfSignedCertificate(X500Principal dn, boolean isCA, String name) {
        SelfSignedX509CertificateAndSigningKey.Builder certificateBuilder = SelfSignedX509CertificateAndSigningKey.builder().setDn(dn).setKeyAlgorithmName("RSA").setSignatureAlgorithmName("SHA1withRSA");
        if (isCA) {
            certificateBuilder.addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647");
        }
        SelfSignedX509CertificateAndSigningKey certificate = certificateBuilder.build();
        X509Certificate issuerCertificate = certificate.getSelfSignedCertificate();
        InfinispanServerDriver.writeKeyStore(this.getCertificateFile(name), ks -> {
            try {
                ks.setCertificateEntry(name, issuerCertificate);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
        return certificate;
    }

    protected void createSignedCertificate(PrivateKey signingKey, PublicKey publicKey, SelfSignedX509CertificateAndSigningKey ca, X500Principal issuerDN, String name, KeyStore trustStore) throws CertificateException {
        X509Certificate caCertificate = ca.getSelfSignedCertificate();
        X509Certificate certificate = new X509CertificateBuilder().setIssuerDn(issuerDN).setSubjectDn(InfinispanServerDriver.dn(name)).setSignatureAlgorithmName("SHA1withRSA").setSigningKey(ca.getSigningKey()).setPublicKey(publicKey).setSerialNumber(BigInteger.valueOf(this.certSerial.getAndIncrement())).addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, false, -1)).build();
        try {
            trustStore.setCertificateEntry(name, certificate);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        InfinispanServerDriver.writeKeyStore(this.getCertificateFile(name), ks -> {
            try {
                ks.setCertificateEntry("ca", caCertificate);
                ks.setKeyEntry(name, signingKey, KEY_PASSWORD.toCharArray(), new X509Certificate[]{certificate, caCertificate});
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void writeKeyStore(File file, Consumer<KeyStore> consumer) {
        try (FileOutputStream os = new FileOutputStream(file);){
            KeyStore keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(null);
            consumer.accept(keyStore);
            keyStore.store(os, KEY_PASSWORD.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void applyKeyStore(ConfigurationBuilder builder, String certificateName) {
        builder.security().ssl().keyStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).keyStorePassword(KEY_PASSWORD.toCharArray());
    }

    public void applyTrustStore(ConfigurationBuilder builder, String certificateName) {
        builder.security().ssl().trustStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).trustStorePassword(KEY_PASSWORD.toCharArray());
    }

    public abstract boolean isRunning(int var1);

    public abstract InetSocketAddress getServerSocket(int var1, int var2);

    public abstract InetAddress getServerAddress(int var1);

    public void pause(int server) {
    }

    public abstract void resume(int var1);

    public abstract void stop(int var1);

    public abstract void kill(int var1);

    public abstract void restart(int var1);

    public abstract void restartCluster();

    public abstract MBeanServerConnection getJmxConnection(int var1);

    public abstract RemoteCacheManager createRemoteCacheManager(ConfigurationBuilder var1);

    public abstract String getLog(int var1);
}

