/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test;

import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.test.fwk.TestResourceTracker;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestThreadTrackerRule
implements TestRule {
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                String testName = description.getTestClass().getName();
                if (description.getMethodName() != null) {
                    throw new IllegalArgumentException(String.format("Please use TestThreadTrackerRule with @ClassRule, %s is using @Rule", testName));
                }
                TestResourceTracker.testStarted((String)testName);
                ThreadLeakChecker.testStarted((String)testName);
                try {
                    base.evaluate();
                }
                finally {
                    TestResourceTracker.testFinished((String)testName);
                    ThreadLeakChecker.testFinished((String)testName);
                }
            }
        };
    }
}

