/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.persistence;

import com.github.dockerjava.api.model.ContainerNetwork;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.server.test.persistence.Database;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;

public class ContainerDatabase
extends Database {
    private static final Log log = LogFactory.getLog(ContainerDatabase.class);
    private static final String ENV_PREFIX = "database.container.env.";
    final GenericContainer container;

    ContainerDatabase(String type, Properties properties) {
        super(type, properties);
        Map<String, String> env = properties.entrySet().stream().filter(e -> e.getKey().toString().startsWith(ENV_PREFIX)).collect(Collectors.toMap(e -> e.getKey().toString().substring(ENV_PREFIX.length()), e -> e.getValue().toString()));
        int port = Integer.parseInt(properties.getProperty("database.container.port"));
        ImageFromDockerfile image = (ImageFromDockerfile)new ImageFromDockerfile().withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(properties.getProperty("database.container.name") + ":" + properties.getProperty("database.container.tag"))).expose(new Integer[]{port})).env(env)).build());
        this.container = new GenericContainer((Future)image).withExposedPorts(new Integer[]{port}).waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    @Override
    public void start() {
        log.infof("Starting database %s", (Object)this.getType());
        this.container.start();
    }

    @Override
    public void stop() {
        log.infof("Stopping database %s", (Object)this.getType());
        this.container.stop();
        log.infof("Stopped database %s", (Object)this.getType());
    }

    @Override
    public String jdbcUrl() {
        String address = ((ContainerNetwork)this.container.getContainerInfo().getNetworkSettings().getNetworks().values().iterator().next()).getIpAddress();
        Properties props = new Properties();
        props.setProperty("container.address", address);
        return StringPropertyReplacer.replaceProperties((String)super.jdbcUrl(), (Properties)props);
    }
}

