/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.usertool;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.infinispan.server.security.UserTool;
import org.infinispan.test.TestingUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class UserToolTest {
    private static String tmpDirectory;
    private static File confDirectory;

    @BeforeClass
    public static void createTestDirectory() {
        tmpDirectory = TestingUtil.tmpDirectory(UserToolTest.class);
        confDirectory = new File(tmpDirectory, "conf");
        confDirectory.mkdirs();
    }

    @Test
    public void testUserToolPlain() throws IOException {
        UserTool userTool = new UserTool();
        userTool.run(new String[]{"-b", "-u", "user", "-p", "password", "-s", tmpDirectory, "-g", "admin"});
        Properties users = new Properties();
        users.load(new FileReader(new File(confDirectory, "users.properties")));
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"password", (Object)users.getProperty("user"));
        Properties groups = new Properties();
        groups.load(new FileReader(new File(confDirectory, "groups.properties")));
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"admin", (Object)groups.getProperty("user"));
    }

    @Test
    public void testUserToolDigest() throws IOException {
        UserTool userTool = new UserTool();
        userTool.run(new String[]{"-b", "-d", "-u", "user", "-p", "password", "-s", tmpDirectory, "-g", "admin"});
        Properties users = new Properties();
        users.load(new FileReader(new File(confDirectory, "users.properties")));
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"98632ccf8d10d1ecc86bb1d1522b4dcf", (Object)users.getProperty("user"));
        Properties groups = new Properties();
        groups.load(new FileReader(new File(confDirectory, "groups.properties")));
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"admin", (Object)groups.getProperty("user"));
    }
}

