/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.server.configuration.ServerConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class JsonSerializationTest {
    private FileLookup fileLookup = FileLookupFactory.newInstance();
    private ObjectMapper objectMapper = new ObjectMapper();
    private Properties properties = new Properties();

    private ServerConfiguration parse() throws Exception {
        this.properties.setProperty("infinispan.server.config.path", System.getProperty("build.directory") + "/test-classes/configuration");
        this.properties.setProperty("test-path", "/path");
        URL url = this.fileLookup.lookupFileLocation("configuration/ServerConfigurationParserTest.xml", JsonSerializationTest.class.getClassLoader());
        ParserRegistry registry = new ParserRegistry(this.getClass().getClassLoader(), false, this.properties);
        ConfigurationBuilderHolder holder = registry.parse(url);
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        return (ServerConfiguration)global.module(ServerConfiguration.class);
    }

    @Test
    public void testJsonSerialization() throws Exception {
        ServerConfiguration serverConfiguration = this.parse();
        JsonWriter writer = new JsonWriter();
        String json = writer.toJSON((ConfigurationInfo)serverConfiguration);
        JsonNode serverNode = this.objectMapper.readTree(json).get("server");
        JsonNode interfaces = serverNode.get("interfaces").get("interface");
        Assert.assertEquals((long)2L, (long)interfaces.size());
        JsonNode interface1 = interfaces.get(0);
        JsonNode interface2 = interfaces.get(1);
        JsonNode address1 = interface1.get("loopback");
        JsonNode address2 = interface2.get("loopback");
        Assert.assertEquals((Object)"default", (Object)interface1.get("name").asText());
        Assert.assertEquals((long)0L, (long)address1.size());
        Assert.assertEquals((Object)"another", (Object)interface2.get("name").asText());
        Assert.assertEquals((long)0L, (long)address2.size());
        JsonNode socketBindings = serverNode.get("socket-bindings");
        Assert.assertEquals((Object)"default", (Object)socketBindings.get("default-interface").asText());
        Assert.assertEquals((long)0L, (long)socketBindings.get("port-offset").asInt());
        JsonNode socketBinding = socketBindings.get("socket-binding");
        Assert.assertEquals((long)5L, (long)socketBinding.size());
        Iterator bindings = socketBinding.elements();
        JsonNode binding1 = (JsonNode)bindings.next();
        Assert.assertEquals((Object)"default", (Object)binding1.get("name").asText());
        Assert.assertEquals((long)11222L, (long)binding1.get("port").asInt());
        JsonNode binding2 = (JsonNode)bindings.next();
        Assert.assertEquals((Object)"hotrod", (Object)binding2.get("name").asText());
        Assert.assertEquals((long)11223L, (long)binding2.get("port").asInt());
        JsonNode binding3 = (JsonNode)bindings.next();
        Assert.assertEquals((Object)"memcached", (Object)binding3.get("name").asText());
        Assert.assertEquals((long)11221L, (long)binding3.get("port").asInt());
        JsonNode binding4 = (JsonNode)bindings.next();
        Assert.assertEquals((Object)"memcached-2", (Object)binding4.get("name").asText());
        Assert.assertEquals((long)12221L, (long)binding4.get("port").asInt());
        JsonNode binding5 = (JsonNode)bindings.next();
        Assert.assertEquals((Object)"rest", (Object)binding5.get("name").asText());
        Assert.assertEquals((long)8080L, (long)binding5.get("port").asInt());
        JsonNode securityRealms = serverNode.get("security").get("security-realms");
        Assert.assertEquals((long)1L, (long)securityRealms.size());
        JsonNode securityRealm = securityRealms.get("security-realm");
        Assert.assertEquals((Object)"default", (Object)securityRealm.get("name").asText());
        JsonNode ssl = securityRealm.get("server-identities").get("ssl");
        JsonNode keyStore = ssl.get("keystore");
        Assert.assertEquals((Object)"ServerConfigurationParserTest-keystore.pfx", (Object)keyStore.get("path").asText());
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)keyStore.get("relative-to").asText());
        Assert.assertEquals((Object)"***", (Object)keyStore.get("keystore-password").asText());
        Assert.assertEquals((Object)"server", (Object)keyStore.get("alias").asText());
        Assert.assertEquals((Object)"***", (Object)keyStore.get("key-password").asText());
        Assert.assertEquals((Object)"localhost", (Object)keyStore.get("generate-self-signed-certificate-host").asText());
        JsonNode engine = ssl.get("engine");
        JsonNode protocols = engine.get("enabled-protocols");
        Iterator protocolItems = protocols.elements();
        Assert.assertEquals((Object)"TLSV1.1", (Object)((JsonNode)protocolItems.next()).asText());
        Assert.assertEquals((Object)"TLSV1.2", (Object)((JsonNode)protocolItems.next()).asText());
        Assert.assertEquals((Object)"TLSV1.3", (Object)((JsonNode)protocolItems.next()).asText());
        JsonNode cipherSuites = engine.get("enabled-ciphersuites");
        Assert.assertEquals((Object)"DHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES128-GCM-SHA256", (Object)cipherSuites.asText());
        JsonNode kerberos = securityRealm.get("server-identities").get("kerberos");
        Assert.assertEquals((Object)"keytab", (Object)kerberos.get("keytab-path").asText());
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)kerberos.get("relative-to").asText());
        JsonNode filesystemRealm = securityRealm.get("filesystem-realm");
        Assert.assertEquals((Object)"security", (Object)filesystemRealm.get("path").asText());
        Assert.assertEquals((long)3L, (long)filesystemRealm.get("levels").asInt());
        Assert.assertFalse((boolean)filesystemRealm.get("encoded").asBoolean());
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)filesystemRealm.get("relative-to").asText());
        JsonNode ldapRealm = securityRealm.get("ldap-realm");
        Assert.assertEquals((Object)"ldap", (Object)ldapRealm.get("name").asText());
        Assert.assertEquals((Object)"ldap://${org.infinispan.test.host.address}:10389", (Object)ldapRealm.get("url").asText());
        Assert.assertEquals((Object)"uid=admin,ou=People,dc=infinispan,dc=org", (Object)ldapRealm.get("principal").asText());
        Assert.assertEquals((Object)"***", (Object)ldapRealm.get("credential").asText());
        JsonNode ldapIdentityMapping = ldapRealm.get("identity-mapping");
        Assert.assertEquals((Object)"uid", (Object)ldapIdentityMapping.get("rdn-identifier").asText());
        Assert.assertEquals((Object)"ou=People,dc=infinispan,dc=org", (Object)ldapIdentityMapping.get("search-base-dn").asText());
        JsonNode attributeMapping = ldapIdentityMapping.get("attribute-mapping");
        JsonNode attributes = attributeMapping.get("attribute");
        Assert.assertEquals((long)3L, (long)attributes.size());
        Iterator elements = attributes.elements();
        JsonNode attribute1 = (JsonNode)elements.next();
        Assert.assertEquals((Object)"cn", (Object)attribute1.get("from").asText());
        Assert.assertEquals((Object)"Roles", (Object)attribute1.get("to").asText());
        Assert.assertEquals((Object)"(&(objectClass=groupOfNames)(member={1}))", (Object)attribute1.get("filter").asText());
        Assert.assertEquals((Object)"ou=Roles,dc=infinispan,dc=org", (Object)attribute1.get("filter-dn").asText());
        JsonNode attribute2 = (JsonNode)elements.next();
        Assert.assertEquals((Object)"cn2", (Object)attribute2.get("from").asText());
        Assert.assertEquals((Object)"Roles2", (Object)attribute2.get("to").asText());
        Assert.assertEquals((Object)"(&(objectClass=GroupOfUniqueNames)(member={0}))", (Object)attribute2.get("filter").asText());
        Assert.assertEquals((Object)"ou=People,dc=infinispan,dc=org", (Object)attribute2.get("filter-dn").asText());
        JsonNode attribute3 = (JsonNode)elements.next();
        Assert.assertEquals((Object)"memberOf", (Object)attribute3.get("reference").asText());
        Assert.assertEquals((Object)"Roles3", (Object)attribute3.get("to").asText());
        JsonNode userPasswordMapping = ldapIdentityMapping.get("user-password-mapper");
        Assert.assertEquals((Object)"userPassword", (Object)userPasswordMapping.get("from").asText());
        Assert.assertFalse((boolean)userPasswordMapping.get("verifiable").asBoolean());
        Assert.assertFalse((boolean)userPasswordMapping.get("writable").asBoolean());
        JsonNode localRealm = securityRealm.get("local-realm");
        Assert.assertEquals((Object)"test-local", (Object)localRealm.get("name").asText());
        JsonNode propertiesRealm = securityRealm.get("properties-realm");
        Assert.assertEquals((Object)"Roles", (Object)propertiesRealm.get("groups-attribute").asText());
        JsonNode userProperties = propertiesRealm.get("user-properties");
        Assert.assertEquals((Object)"ServerConfigurationParserTest-user.properties", (Object)userProperties.get("path").asText());
        Assert.assertEquals((Object)"digest", (Object)userProperties.get("digest-realm-name").asText());
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)userProperties.get("relative-to").asText());
        Assert.assertTrue((boolean)userProperties.get("plain-text").asBoolean());
        JsonNode groupProperties = propertiesRealm.get("group-properties");
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)groupProperties.get("relative-to").asText());
        Assert.assertEquals((Object)"ServerConfigurationParserTest-group.properties", (Object)groupProperties.get("path").asText());
        JsonNode tokenRealm = securityRealm.get("token-realm");
        Assert.assertEquals((Object)"token-test", (Object)tokenRealm.get("name").asText());
        Assert.assertEquals((Object)"username-claim", (Object)tokenRealm.get("principal-claim").asText());
        JsonNode oath = tokenRealm.get("oauth2-introspection");
        Assert.assertEquals((Object)"ANY", (Object)oath.get("host-name-verification-policy").asText());
        Assert.assertEquals((Object)"http://${org.infinispan.test.host.address}:14567/auth/realms/infinispan/protocol/openid-connect/token/introspect", (Object)oath.get("introspection-url").asText());
        Assert.assertEquals((Object)"infinispan-server", (Object)oath.get("client-id").asText());
        Assert.assertEquals((Object)"***", (Object)oath.get("client-secret").asText());
        JsonNode trustStoreRealm = securityRealm.get("truststore-realm");
        Assert.assertEquals((Object)"truststore.p12", (Object)trustStoreRealm.get("path").asText());
        Assert.assertEquals((Object)"SunJSSE", (Object)trustStoreRealm.get("provider").asText());
        Assert.assertEquals((Object)this.properties.getProperty("infinispan.server.config.path"), (Object)trustStoreRealm.get("relative-to").asText());
        Assert.assertEquals((Object)"***", (Object)trustStoreRealm.get("keystore-password").asText());
        JsonNode endpoints = serverNode.get("endpoints");
        Assert.assertEquals((Object)"default", (Object)endpoints.get("socket-binding").asText());
        Assert.assertEquals((Object)"default", (Object)endpoints.get("security-realm").asText());
        JsonNode hotrodConnector = endpoints.get("hotrod-connector");
        JsonNode restConnector = endpoints.get("rest-connector");
        JsonNode memcachedConnector = endpoints.get("memcached-connector");
        this.assertHotRodConnector(hotrodConnector);
        this.assertRestConnector(restConnector);
        this.assertMemcachedConnector(memcachedConnector);
    }

    private void assertHotRodConnector(JsonNode hotrodConnector) {
        Assert.assertEquals((Object)"hotrod", (Object)hotrodConnector.get("name").asText());
        Assert.assertEquals((long)23L, (long)hotrodConnector.get("io-threads").asInt());
        Assert.assertFalse((boolean)hotrodConnector.get("tcp-nodelay").asBoolean());
        Assert.assertEquals((long)20L, (long)hotrodConnector.get("worker-threads").asInt());
        Assert.assertFalse((boolean)hotrodConnector.get("tcp-keepalive").asBoolean());
        Assert.assertEquals((long)10L, (long)hotrodConnector.get("send-buffer-size").asInt());
        Assert.assertEquals((long)20L, (long)hotrodConnector.get("receive-buffer-size").asInt());
        Assert.assertEquals((long)2L, (long)hotrodConnector.get("idle-timeout").asInt());
        Assert.assertEquals((Object)"hotrod", (Object)hotrodConnector.get("socket-binding").asText());
        Assert.assertEquals((Object)"external", (Object)hotrodConnector.get("external-host").asText());
        Assert.assertEquals((long)12345L, (long)hotrodConnector.get("external-port").asInt());
        JsonNode topologyCache = hotrodConnector.get("topology-state-transfer");
        Assert.assertFalse((boolean)topologyCache.get("await-initial-retrieval").asBoolean());
        Assert.assertFalse((boolean)topologyCache.get("lazy-retrieval").asBoolean());
        Assert.assertEquals((long)12L, (long)topologyCache.get("lock-timeout").asInt());
        Assert.assertEquals((long)13L, (long)topologyCache.get("replication-timeout").asInt());
        JsonNode authentication = hotrodConnector.get("authentication");
        Assert.assertEquals((Object)"default", (Object)authentication.get("security-realm").asText());
        JsonNode sasl = authentication.get("sasl");
        Assert.assertEquals((Object)"localhost", (Object)sasl.get("server-name").asText());
        Iterator mechanisms = sasl.get("mechanisms").elements();
        Assert.assertEquals((Object)"GSSAPI", (Object)((JsonNode)mechanisms.next()).asText());
        Assert.assertEquals((Object)"DIGEST-MD5", (Object)((JsonNode)mechanisms.next()).asText());
        Assert.assertEquals((Object)"PLAIN", (Object)((JsonNode)mechanisms.next()).asText());
        Iterator qop = sasl.get("qop").elements();
        Assert.assertEquals((Object)"auth", (Object)((JsonNode)qop.next()).asText());
        Assert.assertEquals((Object)"auth-conf", (Object)((JsonNode)qop.next()).asText());
        Iterator strength = sasl.get("strength").elements();
        Assert.assertEquals((Object)"high", (Object)((JsonNode)strength.next()).asText());
        Assert.assertEquals((Object)"medium", (Object)((JsonNode)strength.next()).asText());
        Assert.assertEquals((Object)"low", (Object)((JsonNode)strength.next()).asText());
        JsonNode policy = sasl.get("policy");
        Assert.assertFalse((boolean)policy.get("forward-secrecy").get("value").asBoolean());
        Assert.assertTrue((boolean)policy.get("no-active").get("value").asBoolean());
        Assert.assertTrue((boolean)policy.get("no-anonymous").get("value").asBoolean());
        Assert.assertFalse((boolean)policy.get("no-dictionary").get("value").asBoolean());
        Assert.assertTrue((boolean)policy.get("no-plain-text").get("value").asBoolean());
        Assert.assertTrue((boolean)policy.get("pass-credentials").get("value").asBoolean());
        JsonNode extraProperties = sasl.get("property");
        Assert.assertEquals((Object)"value1", (Object)extraProperties.get("prop1").asText());
        Assert.assertEquals((Object)"value2", (Object)extraProperties.get("prop2").asText());
        Assert.assertEquals((Object)"value3", (Object)extraProperties.get("prop3").asText());
        JsonNode encryption = hotrodConnector.get("encryption");
        Assert.assertTrue((boolean)encryption.get("require-ssl-client-auth").asBoolean());
        Assert.assertEquals((Object)"default", (Object)encryption.get("security-realm").asText());
        JsonNode sni = encryption.get("sni");
        Assert.assertEquals((long)2L, (long)sni.size());
        Iterator elements = sni.elements();
        JsonNode sni1 = (JsonNode)elements.next();
        Assert.assertEquals((Object)"sni-host-1", (Object)sni1.get("host-name").asText());
        Assert.assertEquals((Object)"default", (Object)sni1.get("security-realm").asText());
        JsonNode sni2 = (JsonNode)elements.next();
        Assert.assertEquals((Object)"sni-host-2", (Object)sni2.get("host-name").asText());
        Assert.assertEquals((Object)"default", (Object)sni2.get("security-realm").asText());
    }

    private void assertRestConnector(JsonNode restConnector) {
        Assert.assertEquals((Object)"rest", (Object)restConnector.get("socket-binding").asText());
        Assert.assertEquals((long)11L, (long)restConnector.get("io-threads").asInt());
        Assert.assertEquals((long)3L, (long)restConnector.get("worker-threads").asInt());
        Assert.assertEquals((Object)"rest", (Object)restConnector.get("name").asText());
        Assert.assertEquals((Object)"rest", (Object)restConnector.get("context-path").asText());
        Assert.assertEquals((Object)"NEVER", (Object)restConnector.get("extended-headers").asText());
        Assert.assertEquals((long)3L, (long)restConnector.get("max-content-length").asInt());
        Assert.assertEquals((long)3L, (long)restConnector.get("compression-level").asInt());
        JsonNode authentication = restConnector.get("authentication");
        Assert.assertEquals((Object)"default", (Object)authentication.get("security-realm").asText());
        JsonNode mechanisms = authentication.get("mechanisms");
        Assert.assertEquals((long)6L, (long)mechanisms.size());
        Iterator items = mechanisms.elements();
        Assert.assertEquals((Object)"DIGEST", (Object)((JsonNode)items.next()).asText());
        Assert.assertEquals((Object)"BASIC", (Object)((JsonNode)items.next()).asText());
        JsonNode corsRules = restConnector.get("cors-rules").get("cors-rule");
        Assert.assertEquals((long)2L, (long)corsRules.size());
        Iterator rules = corsRules.elements();
        JsonNode rule1 = (JsonNode)rules.next();
        Assert.assertEquals((Object)"rule1", (Object)rule1.get("name").asText());
        Assert.assertTrue((boolean)rule1.get("allow-credentials").asBoolean());
        Assert.assertEquals((long)1L, (long)rule1.get("max-age-seconds").asInt());
        this.assertStringArray(Arrays.asList("origin1", "origin2"), rule1.get("allowed-origins"));
        this.assertStringArray(Arrays.asList("GET", "POST"), rule1.get("allowed-methods"));
        this.assertStringArray(Collections.singletonList("Accept"), rule1.get("allowed-headers"));
        this.assertStringArray(Arrays.asList("Accept", "Content-Type"), rule1.get("expose-headers"));
        JsonNode rule2 = (JsonNode)rules.next();
        Assert.assertEquals((Object)"rule2", (Object)rule2.get("name").asText());
        this.assertStringArray(Collections.singletonList("*"), rule2.get("allowed-origins"));
        this.assertStringArray(Arrays.asList("GET", "POST"), rule2.get("allowed-methods"));
        Assert.assertNull((Object)rule2.get("allowed-headers"));
        Assert.assertNull((Object)rule2.get("expose-headers"));
        JsonNode encryption = restConnector.get("encryption");
        Assert.assertFalse((boolean)encryption.get("require-ssl-client-auth").asBoolean());
        Assert.assertEquals((Object)"default", (Object)encryption.get("security-realm").asText());
        JsonNode sni = encryption.get("sni");
        Assert.assertEquals((long)2L, (long)sni.size());
        Iterator elements = sni.elements();
        JsonNode sni1 = (JsonNode)elements.next();
        Assert.assertEquals((Object)"sni-host-3", (Object)sni1.get("host-name").asText());
        Assert.assertEquals((Object)"default", (Object)sni1.get("security-realm").asText());
        JsonNode sni2 = (JsonNode)elements.next();
        Assert.assertEquals((Object)"sni-host-4", (Object)sni2.get("host-name").asText());
        Assert.assertEquals((Object)"default", (Object)sni2.get("security-realm").asText());
    }

    private void assertMemcachedConnector(JsonNode memcachedConnector) {
        Assert.assertEquals((Object)"memcached", (Object)memcachedConnector.get("name").asText());
        Assert.assertEquals((Object)"memcached", (Object)memcachedConnector.get("socket-binding").asText());
        Assert.assertEquals((long)1L, (long)memcachedConnector.get("io-threads").asInt());
        Assert.assertEquals((long)160L, (long)memcachedConnector.get("worker-threads").asInt());
        Assert.assertEquals((long)1L, (long)memcachedConnector.get("idle-timeout").asInt());
        Assert.assertTrue((boolean)memcachedConnector.get("tcp-nodelay").asBoolean());
        Assert.assertTrue((boolean)memcachedConnector.get("tcp-keepalive").asBoolean());
        Assert.assertEquals((long)3L, (long)memcachedConnector.get("send-buffer-size").asInt());
        Assert.assertEquals((long)3L, (long)memcachedConnector.get("receive-buffer-size").asInt());
        Assert.assertEquals((Object)"string", (Object)memcachedConnector.get("cache").asText());
        Assert.assertEquals((Object)"application/json", (Object)memcachedConnector.get("client-encoding").asText());
    }

    private void assertMemcachedConnector2(JsonNode memcachedConnector) {
        Assert.assertEquals((Object)"memcached-2", (Object)memcachedConnector.get("name").asText());
        Assert.assertEquals((Object)"memcached-2", (Object)memcachedConnector.get("socket-binding").asText());
    }

    private void assertStringArray(List<String> expected, JsonNode actual) {
        ArrayNode arrayNode = (ArrayNode)actual;
        List elements = StreamSupport.stream(arrayNode.spliterator(), false).map(JsonNode::asText).collect(Collectors.toList());
        Assert.assertEquals(expected, elements);
    }
}

