/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.usertool;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Properties;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.server.security.UserTool;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.BasicPasswordSpecEncoding;
import org.wildfly.security.password.spec.PasswordSpec;

public class UserToolTest {
    private static String tmpDirectory;
    private static File confDirectory;

    @BeforeClass
    public static void createTestDirectory() {
        tmpDirectory = CommonsTestingUtil.tmpDirectory(UserToolTest.class);
        confDirectory = new File(tmpDirectory, "conf");
        confDirectory.mkdirs();
    }

    @Test
    public void testUserToolClearText() throws IOException {
        UserTool userTool = new UserTool();
        userTool.run(new String[]{"-b", "-c", "-u", "user", "-p", "password", "-s", tmpDirectory, "-g", "admin"});
        Properties users = new Properties();
        users.load(new FileReader(new File(confDirectory, "users.properties")));
        Assert.assertEquals((long)1L, (long)users.size());
        Assert.assertEquals((Object)"password", (Object)users.getProperty("user"));
        Properties groups = new Properties();
        groups.load(new FileReader(new File(confDirectory, "groups.properties")));
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"admin", (Object)groups.getProperty("user"));
    }

    @Test
    public void testUserToolEncrypted() throws Exception {
        UserTool userTool = new UserTool();
        userTool.run(new String[]{"-b", "-e", "-u", "user", "-p", "password", "-s", tmpDirectory, "-g", "admin"});
        Properties users = new Properties();
        users.load(new FileReader(new File(confDirectory, "users.properties")));
        Assert.assertEquals((long)1L, (long)users.size());
        this.assertPassword("password", users.getProperty("user"));
        Properties groups = new Properties();
        groups.load(new FileReader(new File(confDirectory, "groups.properties")));
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"admin", (Object)groups.getProperty("user"));
    }

    private void assertPassword(String clear, String encrypted) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PasswordGuessEvidence evidence = new PasswordGuessEvidence(clear.toCharArray());
        String[] split = encrypted.split(";");
        for (int i = 0; i < split.length; ++i) {
            int colon = split[i].indexOf(58);
            String algorithm = split[i].substring(0, colon);
            String encoded = split[i].substring(colon + 1);
            byte[] passwordBytes = CodePointIterator.ofChars((char[])encoded.toCharArray()).base64Decode().drain();
            PasswordFactory passwordFactory = PasswordFactory.getInstance((String)algorithm);
            PasswordSpec passwordSpec = BasicPasswordSpecEncoding.decode((byte[])passwordBytes);
            PasswordCredential credential = new PasswordCredential(passwordFactory.generatePassword((KeySpec)passwordSpec));
            Assert.assertTrue((String)"Passwords don't match", (boolean)credential.verify((Evidence)evidence));
        }
    }
}

