/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.license;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class LicenseTest {
    private static final Pattern TR_REGEX = Pattern.compile("<tr>(.+?)</tr>", 32);
    private static final Pattern TD_VALUE_REGEX = Pattern.compile("<td>(.+?)</td>", 32);
    private static final String SERVER_OUTPUT_PATH = System.getProperty("server.output.dir");

    @Test
    public void testLicense() throws IOException {
        Set libs = Files.list(this.getLibDir()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(String::valueOf).map(LicenseTest::removeNettyOsName).collect(Collectors.toSet());
        String html = new String(Files.readAllBytes(this.getDependencyHtmlFile()));
        Matcher trMatcher = TR_REGEX.matcher(html);
        ArrayList<String> htmlDependencies = new ArrayList<String>();
        while (trMatcher.find()) {
            String trValue = trMatcher.group(1);
            Matcher tdMatcher = TD_VALUE_REGEX.matcher(trValue);
            if (!tdMatcher.find()) continue;
            tdMatcher.find();
            String artifact = tdMatcher.group(1);
            tdMatcher.find();
            String version = tdMatcher.group(1);
            htmlDependencies.add(String.format("%s-%s.jar", artifact, version));
        }
        libs.removeAll(htmlDependencies);
        for (String lib : libs) {
            System.out.println("Missing: " + lib);
        }
        Assert.assertEquals((long)0L, (long)libs.size());
    }

    private static String removeNettyOsName(String jarFile) {
        return jarFile.replace("netty-transport-native-epoll-linux-x86_64", "netty-transport-native-epoll");
    }

    private Path getLibDir() {
        File libDir = new File(SERVER_OUTPUT_PATH, "lib");
        return libDir.toPath();
    }

    private Path getDependencyHtmlFile() {
        File docsDir = new File(SERVER_OUTPUT_PATH, "docs");
        File licensesDir = new File(docsDir, "licenses");
        File licensesHtmlFile = new File(licensesDir, "licenses.html");
        return licensesHtmlFile.toPath();
    }
}

