/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)org.infinispan.security.Security.doPrivileged(action);
    }

    private static <T> T doPrivilegedExceptionAction(PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)org.infinispan.security.Security.doPrivileged(action);
    }

    static Properties getSystemProperties() {
        return SecurityActions.doPrivileged(System::getProperties);
    }

    static void addSecurityProvider(Provider provider) {
        SecurityActions.doPrivileged(() -> {
            if (Security.getProvider(provider.getName()) == null) {
                Security.insertProviderAt(provider, 1);
            }
            return null;
        });
    }

    static void startCacheManager(EmbeddedCacheManager cacheManager) {
        PrivilegedAction<Void> action = () -> {
            cacheManager.start();
            return null;
        };
        SecurityActions.doPrivileged(action);
    }

    static boolean stopCacheManager(EmbeddedCacheManager cacheManager) {
        PrivilegedAction<Boolean> action = () -> {
            if (cacheManager.getStatus().allowInvocations()) {
                cacheManager.stop();
                return true;
            }
            return false;
        };
        return SecurityActions.doPrivileged(action);
    }

    static void startProtocolServer(ProtocolServer<ProtocolServerConfiguration> server, ProtocolServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        SecurityActions.doPrivileged(() -> {
            server.start(configuration, cacheManager);
            return null;
        });
    }

    static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager manager) {
        return (GlobalConfiguration)SecurityActions.doPrivileged(new GetCacheManagerConfigurationAction(manager));
    }

    static void shutdownCache(EmbeddedCacheManager manager, String name) {
        PrivilegedAction<Void> action = () -> {
            manager.getCache(name).shutdown();
            return null;
        };
        SecurityActions.doPrivileged(action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        GetGlobalComponentRegistryAction action = new GetGlobalComponentRegistryAction(cacheManager);
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static void setInitialContextFactoryBuilder(InitialContextFactoryBuilder initialContextFactoryBuilder) throws PrivilegedActionException {
        SecurityActions.doPrivilegedExceptionAction(() -> {
            NamingManager.setInitialContextFactoryBuilder(initialContextFactoryBuilder);
            return null;
        });
    }
}

