/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.loader;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Properties;

public class Loader {
    public static final String INFINISPAN_SERVER_HOME_PATH = "infinispan.server.home.path";
    public static final String INFINISPAN_SERVER_ROOT_PATH = "infinispan.server.root.path";
    public static final String DEFAULT_SERVER_ROOT_DIR = "server";

    public static void main(String[] args) {
        Loader.run(args, System.getProperties());
    }

    public static void run(String[] args, Properties properties) {
        Path rootLib;
        if (args.length == 0) {
            System.err.println("You must specify a classname to launch");
        }
        String home = properties.getProperty(INFINISPAN_SERVER_HOME_PATH, properties.getProperty("user.dir"));
        ClassLoader bootClassLoader = Loader.class.getClassLoader();
        ClassLoader serverClassLoader = Loader.classLoaderFromPath(Paths.get(home, "lib"), bootClassLoader);
        String root = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-s".equals(args[i]) && i < args.length - 1) {
                root = args[i + 1];
                break;
            }
            if (!args[i].startsWith("--server-root=")) continue;
            root = args[i].substring(args[i].indexOf(61) + 1);
            break;
        }
        if (root == null) {
            root = properties.getProperty(INFINISPAN_SERVER_ROOT_PATH, Paths.get(home, DEFAULT_SERVER_ROOT_DIR).toString());
        }
        ClassLoader rootClassLoader = (rootLib = Paths.get(root, "lib")).toFile().exists() ? Loader.classLoaderFromPath(rootLib, serverClassLoader) : serverClassLoader;
        Thread.currentThread().setContextClassLoader(rootClassLoader);
        try {
            Class<?> mainClass = rootClassLoader.loadClass(args[0]);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            String[] mainArgs = new String[args.length - 1];
            System.arraycopy(args, 1, mainArgs, 0, mainArgs.length);
            mainMethod.invoke(null, new Object[]{mainArgs});
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public static ClassLoader classLoaderFromPath(Path path, ClassLoader parent) {
        try {
            HashMap jars = new HashMap();
            Files.walk(path, new FileVisitOption[0]).filter(f -> f.toString().endsWith(".jar")).forEach(jar -> {
                try {
                    String artifact = Loader.extractArtifactName(jar.getFileName().toString());
                    if (jars.containsKey(artifact)) {
                        throw new IllegalArgumentException("Duplicate JARs:\n" + jar + "\n" + jars.get(artifact));
                    }
                    jars.put(artifact, jar.toUri().toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            });
            URL[] array = jars.values().toArray(new URL[jars.size()]);
            return AccessController.doPrivileged(() -> {
                if (parent == null) {
                    return new URLClassLoader(array);
                }
                return new URLClassLoader(array, parent);
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String extractArtifactName(String filename) {
        int l = filename.length();
        for (int i = 0; i < l; ++i) {
            char c = filename.charAt(i);
            if (c != '-' || i >= l - 1 || (c = filename.charAt(i + 1)) < '0' || c > '9') continue;
            return filename.substring(0, i);
        }
        return filename;
    }
}

