/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.test.junit.JUnitThreadTrackerRule;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.network.SocketBinding;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class ServerConfigurationParserTest {
    @ClassRule
    public static final JUnitThreadTrackerRule tracker = new JUnitThreadTrackerRule();

    @Test
    public void testParser() throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        URL url = fileLookup.lookupFileLocation("configuration/" + this.getClass().getSimpleName() + ".xml", ServerConfigurationParserTest.class.getClassLoader());
        Properties properties = new Properties();
        properties.setProperty("infinispan.server.config.path", System.getProperty("build.directory") + "/test-classes/configuration");
        ParserRegistry registry = new ParserRegistry(this.getClass().getClassLoader(), false, properties);
        ConfigurationBuilderHolder holder = registry.parse(url);
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        ServerConfiguration server = (ServerConfiguration)global.module(ServerConfiguration.class);
        Assert.assertEquals((long)2L, (long)server.networkInterfaces().size());
        NetworkAddress defaultInterface = (NetworkAddress)server.networkInterfaces().get("default");
        Assert.assertNotNull((Object)defaultInterface);
        Assert.assertTrue((boolean)defaultInterface.getAddress().isLoopbackAddress());
        Map socketBindings = server.socketBindings();
        Assert.assertEquals((long)5L, (long)socketBindings.size());
        Assert.assertEquals((long)11221L, (long)((SocketBinding)socketBindings.get("memcached")).getPort());
        Assert.assertEquals((long)12221L, (long)((SocketBinding)socketBindings.get("memcached-2")).getPort());
        Assert.assertEquals((long)11222L, (long)((SocketBinding)socketBindings.get("default")).getPort());
        Assert.assertEquals((long)11223L, (long)((SocketBinding)socketBindings.get("hotrod")).getPort());
        Assert.assertEquals((long)8080L, (long)((SocketBinding)socketBindings.get("rest")).getPort());
        Map dataSources = server.dataSources();
        Assert.assertEquals((long)1L, (long)dataSources.size());
        DataSourceConfiguration dataSource = (DataSourceConfiguration)dataSources.get("database");
        Assert.assertEquals((Object)"jdbc/database", (Object)dataSource.jndiName());
        Assert.assertEquals((Object)"jdbc:h2:tcp://${org.infinispan.test.host.address}:1521/test", (Object)dataSource.url());
        Assert.assertEquals((Object)"test", (Object)dataSource.username());
        Assert.assertEquals((Object)"test", (Object)dataSource.password());
        Assert.assertEquals((Object)"SELECT 1", (Object)dataSource.initialSql());
        Assert.assertEquals((Object)"org.h2.Driver", (Object)dataSource.driver());
        Assert.assertEquals((long)10L, (long)dataSource.maxSize());
        Assert.assertEquals((long)1L, (long)dataSource.minSize());
        Assert.assertEquals((long)1L, (long)dataSource.initialSize());
        Assert.assertEquals((long)1L, (long)dataSource.connectionProperties().size());
        Assert.assertEquals((Object)"somevalue", dataSource.connectionProperties().get("someproperty"));
        List connectors = ((EndpointConfiguration)server.endpoints().endpoints().get(0)).connectors();
        Assert.assertEquals((long)3L, (long)connectors.size());
        Assert.assertTrue((boolean)(connectors.get(0) instanceof HotRodServerConfiguration));
        Assert.assertTrue((boolean)(connectors.get(1) instanceof RestServerConfiguration));
        Assert.assertTrue((boolean)(connectors.get(2) instanceof MemcachedServerConfiguration));
        SinglePortRouterConfiguration singlePortRouter = ((EndpointConfiguration)server.endpoints().endpoints().get(0)).singlePortRouter();
        Assert.assertEquals((Object)((SocketBinding)socketBindings.get("default")).getAddress().getAddress().getHostAddress(), (Object)singlePortRouter.host());
        Assert.assertEquals((long)((SocketBinding)socketBindings.get("default")).getPort(), (long)singlePortRouter.port());
        Assert.assertEquals((long)((SocketBinding)socketBindings.get("memcached")).getPort(), (long)((ProtocolServerConfiguration)((EndpointConfiguration)server.endpoints().endpoints().get(0)).connectors().get(2)).port());
    }
}

