/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.endpoint;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;

public class EndpointsConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> SOCKET_BINDING = AttributeDefinition.builder((String)"socket-binding", null, String.class).build();
    static final AttributeDefinition<String> SECURITY_REALM = AttributeDefinition.builder((String)"security-realm", null, String.class).build();
    static final AttributeDefinition<Boolean> IMPLICIT_CONNECTOR_SECURITY = AttributeDefinition.builder((String)"implicit-connector-security", (Object)false, Boolean.class).build();
    private final List<ProtocolServerConfiguration> connectors;
    private final SinglePortRouterConfiguration singlePort;
    private static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.ENDPOINTS.toString());
    private final AttributeSet attributes;
    private final List<ConfigurationInfo> configs = new ArrayList<ConfigurationInfo>();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(EndpointsConfiguration.class, new AttributeDefinition[]{SOCKET_BINDING, SECURITY_REALM, IMPLICIT_CONNECTOR_SECURITY});
    }

    EndpointsConfiguration(AttributeSet attributes, List<ProtocolServerConfiguration> connectors, SinglePortRouterConfiguration singlePort) {
        this.attributes = attributes.checkProtection();
        this.connectors = connectors;
        this.singlePort = singlePort;
        this.configs.addAll(connectors);
    }

    public List<ConfigurationInfo> subElements() {
        return this.configs;
    }

    public SinglePortRouterConfiguration singlePortRouter() {
        return this.singlePort;
    }

    public List<ProtocolServerConfiguration> connectors() {
        return this.connectors;
    }

    public boolean implicitConnectorSecurity() {
        return (Boolean)this.attributes.attribute(IMPLICIT_CONNECTOR_SECURITY).get();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

