/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.loader;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.infinispan.server.loader.Loader;
import org.infinispan.server.loader.ThreeClass;
import org.infinispan.server.loader.TwoClass;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LoaderTest {
    private static Path lib1;
    private static Path lib2;
    private static Path lib3;

    @BeforeClass
    public static void prepareLibs() throws IOException {
        Path path = Paths.get(System.getProperty("build.directory"), "test-classes", "server");
        lib1 = path.resolve("lib1");
        lib2 = path.resolve("lib2");
        lib3 = Files.createDirectories(lib2.resolve("lib3"), new FileAttribute[0]);
        ((ZipExporter)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"two.jar")).addClasses(new Class[]{TwoClass.class})).as(ZipExporter.class)).exportTo(lib2.resolve("two.jar").toFile(), true);
        ((ZipExporter)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"three.jar")).addClasses(new Class[]{ThreeClass.class})).as(ZipExporter.class)).exportTo(lib3.resolve("three.jar").toFile(), true);
    }

    @Test
    public void testLoaderViaSystemProperty() {
        Properties properties = new Properties();
        properties.put("infinispan.server.lib.path", String.join((CharSequence)File.pathSeparator, lib1.toString(), lib2.toString(), lib3.toString()));
        Loader.run((String[])new String[]{LoaderTest.class.getName()}, (Properties)properties);
    }

    @Test
    public void testLoaderViaPropertyFile() throws IOException {
        Properties properties = new Properties();
        properties.put("infinispan.server.lib.path", String.join((CharSequence)File.pathSeparator, lib1.toString(), lib2.toString(), lib3.toString()));
        Path propertyFile = Paths.get(System.getProperty("build.directory"), "loader.properties");
        try (BufferedWriter w = Files.newBufferedWriter(propertyFile, new OpenOption[0]);){
            properties.store(w, null);
        }
        Loader.run((String[])new String[]{LoaderTest.class.getName(), "-P", propertyFile.toAbsolutePath().toString()}, (Properties)new Properties());
    }

    public static void main(String[] args) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Assert.assertTrue((boolean)(contextClassLoader instanceof URLClassLoader));
        try (InputStream is = contextClassLoader.getResourceAsStream("test.properties");){
            Properties properties = new Properties();
            properties.load(is);
            Assert.assertEquals((Object)"v", (Object)properties.getProperty("k"));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            contextClassLoader.loadClass("org.infinispan.server.loader.TwoClass");
            contextClassLoader.loadClass("org.infinispan.server.loader.ThreeClass");
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

