/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.http.localuser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.manager.action.ReadPropertyAction;
import org.wildfly.security.mechanism.http.UsernamePasswordAuthenticationMechanism;

final class LocalUserAuthenticationMechanism
extends UsernamePasswordAuthenticationMechanism {
    public static final String LOCALUSER_NAME = "LOCALUSER";
    static final String SILENT = "silent";
    public static final String LOCAL_USER_USE_SECURE_RANDOM = "wildfly.http.local-user.use-secure-random";
    public static final String LOCAL_USER_CHALLENGE_PATH = "wildfly.http.local-user.challenge-path";
    public static final String DEFAULT_USER = "wildfly.http.local-user.default-user";
    private static final String CHALLENGE_PREFIX = "Localuser ";
    private static final int PREFIX_LENGTH = "Localuser ".length();
    private static final byte UTF8NUL = 0;
    private final boolean useSecureRandom;
    private final boolean silent;
    private final File basePath;

    LocalUserAuthenticationMechanism(CallbackHandler callbackHandler, boolean silent) {
        super((CallbackHandler)Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler));
        this.silent = silent;
        this.useSecureRandom = true;
        this.basePath = new File(LocalUserAuthenticationMechanism.getProperty("java.io.tmpdir"));
    }

    public String getMechanismName() {
        return LOCALUSER_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        List authorizationValues = request.getRequestHeaderValues("Authorization");
        if (authorizationValues != null) {
            for (String current : authorizationValues) {
                if (!current.startsWith(CHALLENGE_PREFIX)) continue;
                byte[] decodedValue = ByteIterator.ofBytes((byte[])current.substring(PREFIX_LENGTH).getBytes(StandardCharsets.UTF_8)).asUtf8String().base64Decode().drain();
                if (decodedValue.length == 0) {
                    FileOutputStream fos;
                    File challengeFile;
                    Random random = this.getRandom();
                    try {
                        challengeFile = File.createTempFile("local", ".challenge", this.basePath);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        fos = new FileOutputStream(challengeFile);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    boolean ok = false;
                    try {
                        byte[] bytes = new byte[8];
                        random.nextBytes(bytes);
                        try {
                            fos.write(bytes);
                            fos.close();
                            ok = true;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        if (!ok) {
                            this.deleteChallenge(null);
                        }
                        try {
                            fos.close();
                        }
                        catch (Throwable e) {}
                    }
                    String path = challengeFile.getAbsolutePath();
                    byte[] byArray = CodePointIterator.ofString((String)path).asUtf8(true).drain();
                    continue;
                }
                try {
                    request.authenticationComplete();
                    this.succeed();
                    request.authenticationComplete();
                    return;
                }
                catch (IOException | UnsupportedCallbackException e) {
                    throw new HttpAuthenticationException((Throwable)e);
                }
            }
        }
    }

    private void prepareResponse(HttpServerRequest request, HttpServerResponse response) {
        String authHeader;
        if (this.silent && (authHeader = request.getFirstRequestHeaderValue("Authorization")) == null) {
            return;
        }
        StringBuilder sb = new StringBuilder(CHALLENGE_PREFIX);
        response.addResponseHeader("WWW-Authenticate", sb.toString());
        response.setStatusCode(401);
    }

    private static String getProperty(String name) {
        return (String)LocalUserAuthenticationMechanism.doPrivileged(new ReadPropertyAction(name, null));
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    private void deleteChallenge(File challengeFile) {
        if (challengeFile != null) {
            challengeFile.delete();
            challengeFile = null;
        }
    }

    private Random getRandom() {
        if (this.useSecureRandom) {
            return new SecureRandom();
        }
        return new Random();
    }

    private /* synthetic */ void lambda$evaluateRequest$0(HttpServerRequest request, HttpServerResponse response) throws HttpAuthenticationException {
        this.prepareResponse(request, response);
    }
}

