/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import java.util.Map;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.DataSourceConfiguration;

public class DataSourceConfigurationBuilder
implements Builder<DataSourceConfiguration> {
    private final AttributeSet attributes = DataSourceConfiguration.attributeDefinitionSet();

    DataSourceConfigurationBuilder(String name, String jndiName) {
        this.attributes.attribute(DataSourceConfiguration.NAME).set((Object)name);
        this.attributes.attribute(DataSourceConfiguration.JNDI_NAME).set((Object)jndiName);
    }

    public void validate() {
    }

    public DataSourceConfiguration create() {
        return new DataSourceConfiguration(this.attributes.protect());
    }

    public DataSourceConfigurationBuilder read(DataSourceConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public DataSourceConfigurationBuilder driver(String driver) {
        this.attributes.attribute(DataSourceConfiguration.DRIVER).set((Object)driver);
        return this;
    }

    public DataSourceConfigurationBuilder username(String username) {
        this.attributes.attribute(DataSourceConfiguration.USERNAME).set((Object)username);
        return this;
    }

    public DataSourceConfigurationBuilder password(String password) {
        this.attributes.attribute(DataSourceConfiguration.PASSWORD).set((Object)password);
        return this;
    }

    public DataSourceConfigurationBuilder url(String url) {
        this.attributes.attribute(DataSourceConfiguration.URL).set((Object)url);
        return this;
    }

    public DataSourceConfigurationBuilder transactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation transactionIsolation) {
        this.attributes.attribute(DataSourceConfiguration.TRANSACTION_ISOLATION).set((Object)transactionIsolation);
        return this;
    }

    public DataSourceConfigurationBuilder newConnectionSql(String newConnectionSql) {
        this.attributes.attribute(DataSourceConfiguration.INITIAL_SQL).set((Object)newConnectionSql);
        return this;
    }

    public DataSourceConfigurationBuilder maxSize(int maxSize) {
        this.attributes.attribute(DataSourceConfiguration.MAX_SIZE).set((Object)maxSize);
        return this;
    }

    public DataSourceConfigurationBuilder minSize(int minSize) {
        this.attributes.attribute(DataSourceConfiguration.MIN_SIZE).set((Object)minSize);
        return this;
    }

    public DataSourceConfigurationBuilder initialSize(int initialSize) {
        this.attributes.attribute(DataSourceConfiguration.INITIAL_SIZE).set((Object)initialSize);
        return this;
    }

    public DataSourceConfigurationBuilder blockingTimeout(long blockingTimeout) {
        this.attributes.attribute(DataSourceConfiguration.BLOCKING_TIMEOUT).set((Object)blockingTimeout);
        return this;
    }

    public DataSourceConfigurationBuilder backgroundValidation(long backgroundValidation) {
        this.attributes.attribute(DataSourceConfiguration.BACKGROUND_VALIDATION).set((Object)backgroundValidation);
        return this;
    }

    public DataSourceConfigurationBuilder leakDetection(long leakDetection) {
        this.attributes.attribute(DataSourceConfiguration.LEAK_DETECTION).set((Object)leakDetection);
        return this;
    }

    public DataSourceConfigurationBuilder idleRemoval(int idleRemoval) {
        this.attributes.attribute(DataSourceConfiguration.IDLE_REMOVAL).set((Object)idleRemoval);
        return this;
    }

    public DataSourceConfigurationBuilder statistics(boolean enable) {
        this.attributes.attribute(DataSourceConfiguration.STATISTICS).set((Object)enable);
        return this;
    }

    public DataSourceConfigurationBuilder addProperty(String key, String value) {
        Attribute a = this.attributes.attribute(DataSourceConfiguration.CONNECTION_PROPERTIES);
        Map map = (Map)a.get();
        map.put(key, value);
        a.set((Object)map);
        return this;
    }
}

