/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.JsonWriter;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.junit.JUnitThreadTrackerRule;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.network.SocketBinding;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.security.ElytronPasswordProviderSupplier;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.WildFlyElytronCredentialStoreProvider;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;

public class ServerConfigurationParserTest {
    @ClassRule
    public static final JUnitThreadTrackerRule tracker = new JUnitThreadTrackerRule();

    @BeforeClass
    public static void setUp() {
        ServerConfigurationParserTest.registerSecurityProviders();
        ServerConfigurationParserTest.createCredentialStore(ServerConfigurationParserTest.getConfigPath().resolve("credentials.pfx"), "secret");
    }

    @Test
    public void testXMLParser() throws IOException {
        this.validateConfiguration(this.parse(".xml"));
    }

    @Test
    public void testYAMLParser() throws IOException {
        this.validateConfiguration(this.parse(".yml"));
    }

    private void validateConfiguration(ServerConfiguration server) {
        Assert.assertEquals((long)2L, (long)server.networkInterfaces().size());
        NetworkAddress defaultInterface = (NetworkAddress)server.networkInterfaces().get("default");
        Assert.assertNotNull((Object)defaultInterface);
        Assert.assertTrue((boolean)defaultInterface.getAddress().isLoopbackAddress());
        Map socketBindings = server.socketBindings();
        Assert.assertEquals((long)5L, (long)socketBindings.size());
        Assert.assertEquals((long)11221L, (long)((SocketBinding)socketBindings.get("memcached")).getPort());
        Assert.assertEquals((long)12221L, (long)((SocketBinding)socketBindings.get("memcached-2")).getPort());
        Assert.assertEquals((long)11222L, (long)((SocketBinding)socketBindings.get("default")).getPort());
        Assert.assertEquals((long)11223L, (long)((SocketBinding)socketBindings.get("hotrod")).getPort());
        Assert.assertEquals((long)8080L, (long)((SocketBinding)socketBindings.get("rest")).getPort());
        List realms = server.security().realms().realms();
        Assert.assertEquals((long)2L, (long)realms.size());
        RealmConfiguration realmConfiguration = (RealmConfiguration)realms.get(0);
        Assert.assertEquals((Object)"default", (Object)realmConfiguration.name());
        realmConfiguration = (RealmConfiguration)realms.get(1);
        Assert.assertEquals((Object)"using-credentials", (Object)realmConfiguration.name());
        Map dataSources = server.dataSources();
        Assert.assertEquals((long)2L, (long)dataSources.size());
        DataSourceConfiguration dataSource = (DataSourceConfiguration)dataSources.get("database");
        Assert.assertEquals((Object)"jdbc/database", (Object)dataSource.jndiName());
        Assert.assertEquals((Object)"jdbc:h2:tcp://${org.infinispan.test.host.address}:1521/test", (Object)dataSource.url());
        Assert.assertEquals((Object)"test", (Object)dataSource.username());
        Assert.assertEquals((Object)"test", (Object)dataSource.password());
        Assert.assertEquals((Object)"SELECT 1", (Object)dataSource.initialSql());
        Assert.assertEquals((Object)"org.h2.Driver", (Object)dataSource.driver());
        Assert.assertEquals((long)10L, (long)dataSource.maxSize());
        Assert.assertEquals((long)1L, (long)dataSource.minSize());
        Assert.assertEquals((long)1L, (long)dataSource.initialSize());
        Assert.assertEquals((long)1L, (long)dataSource.connectionProperties().size());
        Assert.assertEquals((long)10000L, (long)dataSource.leakDetection());
        Assert.assertEquals((long)1000L, (long)dataSource.backgroundValidation());
        Assert.assertEquals((long)500L, (long)dataSource.validateOnAcquisition());
        Assert.assertEquals((Object)"somevalue", dataSource.connectionProperties().get("someproperty"));
        dataSource = (DataSourceConfiguration)dataSources.get("database-with-credential");
        Assert.assertEquals((Object)"test", (Object)dataSource.password());
        List connectors = ((EndpointConfiguration)server.endpoints().endpoints().get(0)).connectors();
        Assert.assertEquals((long)3L, (long)connectors.size());
        Assert.assertTrue((boolean)(connectors.get(0) instanceof HotRodServerConfiguration));
        Assert.assertTrue((boolean)(connectors.get(1) instanceof RestServerConfiguration));
        Assert.assertTrue((boolean)(connectors.get(2) instanceof MemcachedServerConfiguration));
        SinglePortRouterConfiguration singlePortRouter = ((EndpointConfiguration)server.endpoints().endpoints().get(0)).singlePortRouter();
        Assert.assertEquals((Object)((SocketBinding)socketBindings.get("default")).getAddress().getAddress().getHostAddress(), (Object)singlePortRouter.host());
        Assert.assertEquals((long)((SocketBinding)socketBindings.get("default")).getPort(), (long)singlePortRouter.port());
        Assert.assertEquals((long)((SocketBinding)socketBindings.get("memcached")).getPort(), (long)((ProtocolServerConfiguration)((EndpointConfiguration)server.endpoints().endpoints().get(0)).connectors().get(2)).port());
        Assert.assertEquals((Object)"strongPassword", (Object)realmConfiguration.ldapConfiguration().attributes().attribute("credential").get());
        Assert.assertEquals((Object)"secret", (Object)new String((char[])realmConfiguration.serverIdentitiesConfiguration().sslConfiguration().trustStore().attributes().attribute("password").get()));
        Assert.assertEquals((Object)"1fdca4ec-c416-47e0-867a-3d471af7050f", (Object)realmConfiguration.tokenConfiguration().oauth2Configuration().attributes().attribute("clientSecret").get());
        Assert.assertEquals((Object)"password", (Object)new String((char[])realmConfiguration.serverIdentitiesConfiguration().sslConfiguration().keyStore().attributes().attribute("keystorePassword").get()));
    }

    @Test
    public void testJsonSerialization() throws IOException {
        ServerConfiguration serverConfiguration = this.parse(".xml");
        String serverConfigPath = ServerConfigurationParserTest.getConfigPath().toString();
        JsonWriter writer = new JsonWriter();
        String json = writer.toJSON((ConfigurationInfo)serverConfiguration);
        Json serverNode = Json.read((String)json).at("server");
        Json interfaces = serverNode.at("interfaces").at("interface");
        Assert.assertEquals((long)2L, (long)interfaces.asList().size());
        Json interface1 = interfaces.at(0);
        Json interface2 = interfaces.at(1);
        Json address1 = interface1.at("loopback");
        Json address2 = interface2.at("loopback");
        Assert.assertEquals((Object)"default", (Object)interface1.at("name").asString());
        Assert.assertEquals((long)0L, (long)address1.asMap().size());
        Assert.assertEquals((Object)"another", (Object)interface2.at("name").asString());
        Assert.assertEquals((long)0L, (long)address2.asMap().size());
        Json socketBindings = serverNode.at("socket-bindings");
        Assert.assertEquals((Object)"default", (Object)socketBindings.at("default-interface").asString());
        Assert.assertEquals((long)0L, (long)socketBindings.at("port-offset").asInteger());
        Json socketBinding = socketBindings.at("socket-binding");
        Assert.assertEquals((long)5L, (long)socketBinding.asList().size());
        Iterator bindings = socketBinding.asJsonList().iterator();
        Json binding1 = (Json)bindings.next();
        Assert.assertEquals((Object)"default", (Object)binding1.at("name").asString());
        Assert.assertEquals((long)11222L, (long)binding1.at("port").asInteger());
        Json binding2 = (Json)bindings.next();
        Assert.assertEquals((Object)"hotrod", (Object)binding2.at("name").asString());
        Assert.assertEquals((long)11223L, (long)binding2.at("port").asInteger());
        Json binding3 = (Json)bindings.next();
        Assert.assertEquals((Object)"memcached", (Object)binding3.at("name").asString());
        Assert.assertEquals((long)11221L, (long)binding3.at("port").asInteger());
        Json binding4 = (Json)bindings.next();
        Assert.assertEquals((Object)"memcached-2", (Object)binding4.at("name").asString());
        Assert.assertEquals((long)12221L, (long)binding4.at("port").asInteger());
        Json binding5 = (Json)bindings.next();
        Assert.assertEquals((Object)"rest", (Object)binding5.at("name").asString());
        Assert.assertEquals((long)8080L, (long)binding5.at("port").asInteger());
        Json credentialStores = serverNode.at("security").at("credential-stores");
        Assert.assertEquals((long)1L, (long)credentialStores.asMap().size());
        Json credentialStore = credentialStores.at("credential-store");
        Assert.assertEquals((Object)"credentials.pfx", (Object)credentialStore.at("path").asString());
        Json securityRealms = serverNode.at("security").at("security-realms");
        Assert.assertEquals((long)1L, (long)securityRealms.asMap().size());
        Json securityRealm = securityRealms.at("security-realm");
        Assert.assertEquals((long)2L, (long)securityRealm.asList().size());
        Json defaultRealm = securityRealm.at(0);
        Assert.assertEquals((Object)"default", (Object)defaultRealm.at("name").asString());
        Json ssl = defaultRealm.at("server-identities").at("ssl");
        Json keyStore = ssl.at("keystore");
        Assert.assertEquals((Object)"ServerConfigurationParserTest-keystore.pfx", (Object)keyStore.at("path").asString());
        Assert.assertEquals((Object)serverConfigPath, (Object)keyStore.at("relative-to").asString());
        Assert.assertEquals((Object)"***", (Object)keyStore.at("keystore-password").asString());
        Assert.assertEquals((Object)"server", (Object)keyStore.at("alias").asString());
        Assert.assertEquals((Object)"***", (Object)keyStore.at("key-password").asString());
        Assert.assertEquals((Object)"localhost", (Object)keyStore.at("generate-self-signed-certificate-host").asString());
        Json engine = ssl.at("engine");
        Json protocols = engine.at("enabled-protocols");
        Iterator protocolItems = protocols.asJsonList().iterator();
        Assert.assertEquals((Object)"TLSV1.1", (Object)((Json)protocolItems.next()).asString());
        Assert.assertEquals((Object)"TLSV1.2", (Object)((Json)protocolItems.next()).asString());
        Assert.assertEquals((Object)"TLSV1.3", (Object)((Json)protocolItems.next()).asString());
        Json cipherSuites = engine.at("enabled-ciphersuites");
        Assert.assertEquals((Object)"DHE-RSA-AES256-GCM-SHA384:DHE-RSA-AES128-GCM-SHA256", (Object)cipherSuites.asString());
        Json kerberos = defaultRealm.at("server-identities").at("kerberos");
        Assert.assertEquals((Object)"keytab", (Object)kerberos.at("keytab-path").asString());
        Assert.assertEquals((Object)serverConfigPath, (Object)kerberos.at("relative-to").asString());
        Json filesystemRealm = defaultRealm.at("filesystem-realm");
        Assert.assertEquals((Object)"security", (Object)filesystemRealm.at("path").asString());
        Assert.assertEquals((long)3L, (long)filesystemRealm.at("levels").asInteger());
        Assert.assertFalse((boolean)filesystemRealm.at("encoded").asBoolean());
        Assert.assertEquals((Object)serverConfigPath, (Object)filesystemRealm.at("relative-to").asString());
        Json ldapRealm = defaultRealm.at("ldap-realm");
        Assert.assertEquals((Object)"ldap", (Object)ldapRealm.at("name").asString());
        Assert.assertEquals((Object)"ldap://${org.infinispan.test.host.address}:10389", (Object)ldapRealm.at("url").asString());
        Assert.assertEquals((Object)"uid=admin,ou=People,dc=infinispan,dc=org", (Object)ldapRealm.at("principal").asString());
        Assert.assertEquals((Object)"***", (Object)ldapRealm.at("credential").asString());
        Assert.assertEquals((Object)"org.wildfly.security.auth.util.RegexNameRewriter", (Object)ldapRealm.at("name-rewriter").asString());
        Json ldapIdentityMapping = ldapRealm.at("identity-mapping");
        Assert.assertEquals((Object)"uid", (Object)ldapIdentityMapping.at("rdn-identifier").asString());
        Assert.assertEquals((Object)"ou=People,dc=infinispan,dc=org", (Object)ldapIdentityMapping.at("search-base-dn").asString());
        Json attributeMapping = ldapIdentityMapping.at("attribute-mapping");
        Json attributes = attributeMapping.at("attribute");
        Assert.assertEquals((long)3L, (long)attributes.asList().size());
        Iterator elements = attributes.asJsonList().iterator();
        Json attribute1 = (Json)elements.next();
        Assert.assertEquals((Object)"cn", (Object)attribute1.at("from").asString());
        Assert.assertEquals((Object)"Roles", (Object)attribute1.at("to").asString());
        Assert.assertEquals((Object)"(&(objectClass=groupOfNames)(member={1}))", (Object)attribute1.at("filter").asString());
        Assert.assertEquals((Object)"ou=Roles,dc=infinispan,dc=org", (Object)attribute1.at("filter-dn").asString());
        Json attribute2 = (Json)elements.next();
        Assert.assertEquals((Object)"cn2", (Object)attribute2.at("from").asString());
        Assert.assertEquals((Object)"Roles2", (Object)attribute2.at("to").asString());
        Assert.assertEquals((Object)"(&(objectClass=GroupOfUniqueNames)(member={0}))", (Object)attribute2.at("filter").asString());
        Assert.assertEquals((Object)"ou=People,dc=infinispan,dc=org", (Object)attribute2.at("filter-dn").asString());
        Json attribute3 = (Json)elements.next();
        Assert.assertEquals((Object)"memberOf", (Object)attribute3.at("reference").asString());
        Assert.assertEquals((Object)"Roles3", (Object)attribute3.at("to").asString());
        Json userPasswordMapping = ldapIdentityMapping.at("user-password-mapper");
        Assert.assertEquals((Object)"userPassword", (Object)userPasswordMapping.at("from").asString());
        Assert.assertFalse((boolean)userPasswordMapping.at("verifiable").asBoolean());
        Assert.assertFalse((boolean)userPasswordMapping.at("writable").asBoolean());
        Json localRealm = defaultRealm.at("local-realm");
        Assert.assertEquals((Object)"test-local", (Object)localRealm.at("name").asString());
        Json propertiesRealm = defaultRealm.at("properties-realm");
        Assert.assertEquals((Object)"Roles", (Object)propertiesRealm.at("groups-attribute").asString());
        Json userProperties = propertiesRealm.at("user-properties");
        Assert.assertEquals((Object)"ServerConfigurationParserTest-user.properties", (Object)userProperties.at("path").asString());
        Assert.assertEquals((Object)"digest", (Object)userProperties.at("digest-realm-name").asString());
        Assert.assertEquals((Object)serverConfigPath, (Object)userProperties.at("relative-to").asString());
        Assert.assertTrue((boolean)userProperties.at("plain-text").asBoolean());
        Json groupProperties = propertiesRealm.at("group-properties");
        Assert.assertEquals((Object)serverConfigPath, (Object)groupProperties.at("relative-to").asString());
        Assert.assertEquals((Object)"ServerConfigurationParserTest-group.properties", (Object)groupProperties.at("path").asString());
        Json tokenRealm = defaultRealm.at("token-realm");
        Assert.assertEquals((Object)"token-test", (Object)tokenRealm.at("name").asString());
        Assert.assertEquals((Object)"username-claim", (Object)tokenRealm.at("principal-claim").asString());
        Json oauth = tokenRealm.at("oauth2-introspection");
        Assert.assertEquals((Object)"ANY", (Object)oauth.at("host-name-verification-policy").asString());
        Assert.assertEquals((Object)"http://${org.infinispan.test.host.address}:14567/auth/realms/infinispan/protocol/openid-connect/token/introspect", (Object)oauth.at("introspection-url").asString());
        Assert.assertEquals((Object)"infinispan-server", (Object)oauth.at("client-id").asString());
        Assert.assertEquals((Object)"***", (Object)oauth.at("client-secret").asString());
        Json trustStoreRealm = defaultRealm.at("truststore-realm");
        Assert.assertEquals((long)1L, (long)trustStoreRealm.asMap().size());
        Assert.assertEquals((Object)"trust", (Object)trustStoreRealm.at("name").asString());
        Json endpoints = serverNode.at("endpoints");
        Assert.assertEquals((Object)"default", (Object)endpoints.at("socket-binding").asString());
        Assert.assertEquals((Object)"default", (Object)endpoints.at("security-realm").asString());
        Json hotrodConnector = endpoints.at("hotrod-connector");
        Json restConnector = endpoints.at("rest-connector");
        Json memcachedConnector = endpoints.at("memcached-connector");
        this.assertHotRodConnector(hotrodConnector);
        this.assertRestConnector(restConnector);
        this.assertMemcachedConnector(memcachedConnector);
    }

    ServerConfiguration parse(String extension) throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        URL url = fileLookup.lookupFileLocation("configuration/" + this.getClass().getSimpleName() + extension, ServerConfigurationParserTest.class.getClassLoader());
        Properties properties = new Properties();
        properties.setProperty("infinispan.server.config.path", ServerConfigurationParserTest.getConfigPath().toString());
        ParserRegistry registry = new ParserRegistry(this.getClass().getClassLoader(), false, properties);
        ConfigurationBuilderHolder holder = registry.parse(url);
        GlobalConfiguration global = holder.getGlobalConfigurationBuilder().build();
        return (ServerConfiguration)global.module(ServerConfiguration.class);
    }

    private void assertHotRodConnector(Json hotrodConnector) {
        Assert.assertEquals((Object)"hotrod", (Object)hotrodConnector.at("name").asString());
        Assert.assertEquals((long)23L, (long)hotrodConnector.at("io-threads").asInteger());
        Assert.assertFalse((boolean)hotrodConnector.at("tcp-nodelay").asBoolean());
        Assert.assertEquals((long)20L, (long)hotrodConnector.at("worker-threads").asInteger());
        Assert.assertFalse((boolean)hotrodConnector.at("tcp-keepalive").asBoolean());
        Assert.assertEquals((long)10L, (long)hotrodConnector.at("send-buffer-size").asInteger());
        Assert.assertEquals((long)20L, (long)hotrodConnector.at("receive-buffer-size").asInteger());
        Assert.assertEquals((long)2L, (long)hotrodConnector.at("idle-timeout").asInteger());
        Assert.assertEquals((Object)"hotrod", (Object)hotrodConnector.at("socket-binding").asString());
        Assert.assertEquals((Object)"external", (Object)hotrodConnector.at("external-host").asString());
        Assert.assertEquals((long)12345L, (long)hotrodConnector.at("external-port").asInteger());
        Json topologyCache = hotrodConnector.at("topology-state-transfer");
        Assert.assertFalse((boolean)topologyCache.at("await-initial-retrieval").asBoolean());
        Assert.assertFalse((boolean)topologyCache.at("lazy-retrieval").asBoolean());
        Assert.assertEquals((long)12L, (long)topologyCache.at("lock-timeout").asInteger());
        Assert.assertEquals((long)13L, (long)topologyCache.at("replication-timeout").asInteger());
        Json authentication = hotrodConnector.at("authentication");
        Assert.assertEquals((Object)"default", (Object)authentication.at("security-realm").asString());
        Json sasl = authentication.at("sasl");
        Assert.assertEquals((Object)"localhost", (Object)sasl.at("server-name").asString());
        Iterator mechanisms = sasl.at("mechanisms").asJsonList().iterator();
        Assert.assertEquals((Object)"GSSAPI", (Object)((Json)mechanisms.next()).asString());
        Assert.assertEquals((Object)"DIGEST-MD5", (Object)((Json)mechanisms.next()).asString());
        Assert.assertEquals((Object)"PLAIN", (Object)((Json)mechanisms.next()).asString());
        Iterator qop = sasl.at("qop").asJsonList().iterator();
        Assert.assertEquals((Object)"auth", (Object)((Json)qop.next()).asString());
        Assert.assertEquals((Object)"auth-conf", (Object)((Json)qop.next()).asString());
        Iterator strength = sasl.at("strength").asJsonList().iterator();
        Assert.assertEquals((Object)"high", (Object)((Json)strength.next()).asString());
        Assert.assertEquals((Object)"medium", (Object)((Json)strength.next()).asString());
        Assert.assertEquals((Object)"low", (Object)((Json)strength.next()).asString());
        Json policy = sasl.at("policy");
        Assert.assertFalse((boolean)policy.at("forward-secrecy").at("value").asBoolean());
        Assert.assertTrue((boolean)policy.at("no-active").at("value").asBoolean());
        Assert.assertTrue((boolean)policy.at("no-anonymous").at("value").asBoolean());
        Assert.assertFalse((boolean)policy.at("no-dictionary").at("value").asBoolean());
        Assert.assertTrue((boolean)policy.at("no-plain-text").at("value").asBoolean());
        Assert.assertTrue((boolean)policy.at("pass-credentials").at("value").asBoolean());
        Json extraProperties = sasl.at("property");
        Assert.assertEquals((Object)"value1", (Object)extraProperties.at("prop1").asString());
        Assert.assertEquals((Object)"value2", (Object)extraProperties.at("prop2").asString());
        Assert.assertEquals((Object)"value3", (Object)extraProperties.at("prop3").asString());
        Json encryption = hotrodConnector.at("encryption");
        Assert.assertTrue((boolean)encryption.at("require-ssl-client-auth").asBoolean());
        Assert.assertEquals((Object)"default", (Object)encryption.at("security-realm").asString());
        Json sni = encryption.at("sni");
        Assert.assertEquals((long)2L, (long)sni.asList().size());
        Iterator elements = sni.asJsonList().iterator();
        Json sni1 = (Json)elements.next();
        Assert.assertEquals((Object)"sni-host-1", (Object)sni1.at("host-name").asString());
        Assert.assertEquals((Object)"default", (Object)sni1.at("security-realm").asString());
        Json sni2 = (Json)elements.next();
        Assert.assertEquals((Object)"sni-host-2", (Object)sni2.at("host-name").asString());
        Assert.assertEquals((Object)"default", (Object)sni2.at("security-realm").asString());
    }

    private void assertRestConnector(Json restConnector) {
        Assert.assertEquals((Object)"rest", (Object)restConnector.at("socket-binding").asString());
        Assert.assertEquals((long)11L, (long)restConnector.at("io-threads").asInteger());
        Assert.assertEquals((long)3L, (long)restConnector.at("worker-threads").asInteger());
        Assert.assertEquals((Object)"rest", (Object)restConnector.at("name").asString());
        Assert.assertEquals((Object)"rest", (Object)restConnector.at("context-path").asString());
        Assert.assertEquals((Object)"NEVER", (Object)restConnector.at("extended-headers").asString());
        Assert.assertEquals((long)3L, (long)restConnector.at("max-content-length").asInteger());
        Assert.assertEquals((long)3L, (long)restConnector.at("compression-level").asInteger());
        Json authentication = restConnector.at("authentication");
        Assert.assertEquals((Object)"default", (Object)authentication.at("security-realm").asString());
        Json mechanisms = authentication.at("mechanisms");
        Assert.assertEquals((long)2L, (long)mechanisms.asList().size());
        Iterator items = mechanisms.asJsonList().iterator();
        Assert.assertEquals((Object)"DIGEST", (Object)((Json)items.next()).asString());
        Assert.assertEquals((Object)"BASIC", (Object)((Json)items.next()).asString());
        Json corsRules = restConnector.at("cors-rules").at("cors-rule");
        Assert.assertEquals((long)2L, (long)corsRules.asList().size());
        Iterator rules = corsRules.asJsonList().iterator();
        Json rule1 = (Json)rules.next();
        Assert.assertEquals((Object)"rule1", (Object)rule1.at("name").asString());
        Assert.assertTrue((boolean)rule1.at("allow-credentials").asBoolean());
        Assert.assertEquals((long)1L, (long)rule1.at("max-age-seconds").asInteger());
        this.assertStringArray(Arrays.asList("origin1", "origin2"), rule1.at("allowed-origins"));
        this.assertStringArray(Arrays.asList("GET", "POST"), rule1.at("allowed-methods"));
        this.assertStringArray(Collections.singletonList("Accept"), rule1.at("allowed-headers"));
        this.assertStringArray(Arrays.asList("Accept", "Content-Type"), rule1.at("expose-headers"));
        Json rule2 = (Json)rules.next();
        Assert.assertEquals((Object)"rule2", (Object)rule2.at("name").asString());
        this.assertStringArray(Collections.singletonList("*"), rule2.at("allowed-origins"));
        this.assertStringArray(Arrays.asList("GET", "POST"), rule2.at("allowed-methods"));
        Assert.assertNull((Object)rule2.at("allowed-headers"));
        Assert.assertNull((Object)rule2.at("expose-headers"));
        Json encryption = restConnector.at("encryption");
        Assert.assertFalse((boolean)encryption.at("require-ssl-client-auth").asBoolean());
        Assert.assertEquals((Object)"default", (Object)encryption.at("security-realm").asString());
        Json sni = encryption.at("sni");
        Assert.assertEquals((long)2L, (long)sni.asList().size());
        Iterator elements = sni.asJsonList().iterator();
        Json sni1 = (Json)elements.next();
        Assert.assertEquals((Object)"sni-host-3", (Object)sni1.at("host-name").asString());
        Assert.assertEquals((Object)"default", (Object)sni1.at("security-realm").asString());
        Json sni2 = (Json)elements.next();
        Assert.assertEquals((Object)"sni-host-4", (Object)sni2.at("host-name").asString());
        Assert.assertEquals((Object)"default", (Object)sni2.at("security-realm").asString());
    }

    private void assertMemcachedConnector(Json memcachedConnector) {
        Assert.assertEquals((Object)"memcached", (Object)memcachedConnector.at("name").asString());
        Assert.assertEquals((Object)"memcached", (Object)memcachedConnector.at("socket-binding").asString());
        Assert.assertEquals((long)1L, (long)memcachedConnector.at("io-threads").asInteger());
        Assert.assertEquals((long)160L, (long)memcachedConnector.at("worker-threads").asInteger());
        Assert.assertEquals((long)1L, (long)memcachedConnector.at("idle-timeout").asInteger());
        Assert.assertTrue((boolean)memcachedConnector.at("tcp-nodelay").asBoolean());
        Assert.assertTrue((boolean)memcachedConnector.at("tcp-keepalive").asBoolean());
        Assert.assertEquals((long)3L, (long)memcachedConnector.at("send-buffer-size").asInteger());
        Assert.assertEquals((long)3L, (long)memcachedConnector.at("receive-buffer-size").asInteger());
        Assert.assertEquals((Object)"string", (Object)memcachedConnector.at("cache").asString());
        Assert.assertEquals((Object)"application/json", (Object)memcachedConnector.at("client-encoding").asString());
    }

    private void assertStringArray(List<String> expected, Json actual) {
        List elements = actual.asJsonList().stream().map(Json::asString).collect(Collectors.toList());
        Assert.assertEquals(expected, elements);
    }

    public static Path getConfigPath() {
        return Paths.get(System.getProperty("build.directory"), "test-classes", "configuration");
    }

    public static void registerSecurityProviders() {
        WildFlyElytronCredentialStoreProvider provider = WildFlyElytronCredentialStoreProvider.getInstance();
        if (Security.getProvider(provider.getName()) == null) {
            Security.insertProviderAt((Provider)provider, 1);
        }
    }

    static void addCredential(KeyStoreCredentialStore store, String alias, String credential) {
        try {
            store.store(alias, (Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])credential.toCharArray())), null);
            store.flush();
        }
        catch (CredentialStoreException e) {
            throw new RuntimeException(e);
        }
    }

    static KeyStoreCredentialStore newCredentialStore(Path location, String secret) {
        Exceptions.unchecked(() -> {
            Files.deleteIfExists(location);
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
        });
        KeyStoreCredentialStore credentialStore = new KeyStoreCredentialStore();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("location", location.toString());
        map.put("create", "true");
        try {
            credentialStore.initialize(map, (CredentialStore.ProtectionParameter)new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])secret.toCharArray())))), ElytronPasswordProviderSupplier.PROVIDERS);
            return credentialStore;
        }
        catch (CredentialStoreException e) {
            throw new RuntimeException(e);
        }
    }

    static void createCredentialStore(Path location, String secret) {
        KeyStoreCredentialStore credentialStore = ServerConfigurationParserTest.newCredentialStore(location, secret);
        ServerConfigurationParserTest.addCredential(credentialStore, "ldap", "strongPassword");
        ServerConfigurationParserTest.addCredential(credentialStore, "db", "test");
        ServerConfigurationParserTest.addCredential(credentialStore, "keystore", "password");
        ServerConfigurationParserTest.addCredential(credentialStore, "oauth2", "1fdca4ec-c416-47e0-867a-3d471af7050f");
        ServerConfigurationParserTest.addCredential(credentialStore, "trust", "secret");
    }
}

