/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Properties;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.JwtConfiguration;
import org.infinispan.server.configuration.security.OAuth2Configuration;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.security.KeycloakRoleDecoder;
import org.infinispan.server.security.ServerSecurityRealm;
import org.wildfly.security.auth.realm.token.TokenSecurityRealm;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.RoleDecoder;

public class TokenRealmConfiguration
extends ConfigurationElement<TokenRealmConfiguration>
implements RealmProvider {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, (Object)"token", String.class).build();
    static final AttributeDefinition<String> AUTH_SERVER_URL = AttributeDefinition.builder((Enum)Attribute.AUTH_SERVER_URL, null, String.class).build();
    static final AttributeDefinition<String> CLIENT_ID = AttributeDefinition.builder((Enum)Attribute.CLIENT_ID, null, String.class).build();
    static final AttributeDefinition<String> PRINCIPAL_CLAIM = AttributeDefinition.builder((Enum)Attribute.PRINCIPAL_CLAIM, null, String.class).build();
    private final JwtConfiguration jwtConfiguration;
    private final OAuth2Configuration oauth2Configuration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(TokenRealmConfiguration.class, new AttributeDefinition[]{NAME, AUTH_SERVER_URL, CLIENT_ID, PRINCIPAL_CLAIM});
    }

    TokenRealmConfiguration(JwtConfiguration jwtConfiguration, OAuth2Configuration oAuth2Configuration, AttributeSet attributes) {
        super((Enum)Element.TOKEN_REALM, attributes, new ConfigurationElement[0]);
        this.jwtConfiguration = jwtConfiguration;
        this.oauth2Configuration = oAuth2Configuration;
    }

    @Override
    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public String authServerUrl() {
        return (String)this.attributes.attribute(AUTH_SERVER_URL).get();
    }

    public String clientId() {
        return (String)this.attributes.attribute(CLIENT_ID).get();
    }

    public JwtConfiguration jwtConfiguration() {
        return this.jwtConfiguration;
    }

    public OAuth2Configuration oauth2Configuration() {
        return this.oauth2Configuration;
    }

    @Override
    public SecurityRealm build(SecurityConfiguration security, RealmConfiguration realm, SecurityDomain.Builder domainBuilder, Properties properties) {
        TokenSecurityRealm.Builder tokenRealmBuilder = TokenSecurityRealm.builder();
        tokenRealmBuilder.validator(this.oauth2Configuration().isModified() ? this.oauth2Configuration.getValidator(security) : this.jwtConfiguration.getValidator(security));
        TokenSecurityRealm securityRealm = tokenRealmBuilder.build();
        realm.addFeature(ServerSecurityRealm.Feature.TOKEN);
        domainBuilder.setRoleDecoder((RoleDecoder)new KeycloakRoleDecoder());
        return securityRealm;
    }
}

